/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import org.coode.owlapi.rdf.model.AbstractTranslator;
import org.coode.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class RDFTranslator
extends AbstractTranslator<RDFNode, RDFResource, RDFResourceIRI, RDFLiteral> {
    private RDFGraph graph = new RDFGraph();

    public RDFTranslator(OWLOntologyManager manager, OWLOntology ontology, boolean useStrongTyping) {
        super(manager, ontology, useStrongTyping);
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    @Override
    protected void addTriple(RDFResource subject, RDFResourceIRI pred, RDFNode object) {
        this.graph.addTriple(new RDFTriple(subject, pred, object));
    }

    @Override
    protected RDFResourceBlankNode getAnonymousNode(Object key) {
        if (key instanceof OWLAnonymousIndividual) {
            RDFResourceBlankNode toReturn = new RDFResourceBlankNode(((OWLAnonymousIndividual)key).getID().getID().hashCode());
            return toReturn;
        }
        RDFResourceBlankNode toReturn = new RDFResourceBlankNode(System.identityHashCode(key));
        return toReturn;
    }

    @Override
    protected RDFLiteral getLiteralNode(OWLLiteral literal) {
        return RDFTranslator.translateLiteralNode(literal);
    }

    public static RDFLiteral translateLiteralNode(OWLLiteral literal) {
        if (!literal.isRDFPlainLiteral()) {
            return new RDFLiteral(literal.getLiteral(), literal.getDatatype().getIRI());
        }
        return new RDFLiteral(literal.getLiteral(), literal.hasLang() ? literal.getLang() : null);
    }

    @Override
    protected RDFResourceIRI getPredicateNode(IRI uri) {
        return new RDFResourceIRI(uri);
    }

    @Override
    protected RDFResourceIRI getResourceNode(IRI uri) {
        return new RDFResourceIRI(uri);
    }

    public void reset() {
        this.graph = new RDFGraph();
    }
}

