/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.model;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFGraph {
    private static final Logger logger = LoggerFactory.getLogger(RDFGraph.class);
    private Map<RDFResource, Set<RDFTriple>> triplesBySubject;
    private Set<RDFResourceBlankNode> rootAnonymousNodes = null;
    private Set<RDFTriple> triples = new HashSet<RDFTriple>();

    public RDFGraph() {
        this.triplesBySubject = new HashMap<RDFResource, Set<RDFTriple>>();
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public void addTriple(RDFTriple triple) {
        this.rootAnonymousNodes = null;
        this.triples.add(triple);
        Set<RDFTriple> tripleSet = this.triplesBySubject.get(triple.getSubject());
        if (tripleSet == null) {
            tripleSet = new HashSet<RDFTriple>();
            this.triplesBySubject.put(triple.getSubject(), tripleSet);
        }
        tripleSet.add(triple);
    }

    @Deprecated
    public Set<RDFTriple> getTriplesForSubject(RDFResource subject) {
        if (this.triplesBySubject.containsKey(subject)) {
            return new HashSet<RDFTriple>((Collection)this.triplesBySubject.get(subject));
        }
        return Collections.emptySet();
    }

    public List<RDFTriple> getSortedTriplesForSubject(RDFNode subject, boolean sort) {
        ArrayList<RDFTriple> toReturn = new ArrayList<RDFTriple>();
        Set<RDFTriple> set = this.triplesBySubject.get(subject);
        if (set != null) {
            toReturn.addAll(set);
        }
        if (sort) {
            try {
                Collections.sort(toReturn);
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().contains("Comparison method violates its general contract!")) {
                    throw e;
                }
                logger.warn("Misbehaving triple comparator, leaving triples unsorted: {}", toReturn, (Object)e);
            }
        }
        return toReturn;
    }

    public boolean isAnonymousNodeSharedSubject(RDFResourceBlankNode node) {
        if (!node.isAnonymous()) {
            return false;
        }
        int count = 0;
        for (RDFTriple triple : this.triples) {
            RDFResourceBlankNode object;
            if (!(triple.getObject() instanceof RDFResourceBlankNode) || !(object = (RDFResourceBlankNode)triple.getObject()).equals((Object)node) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    public Set<RDFResourceBlankNode> getRootAnonymousNodes() {
        if (this.rootAnonymousNodes == null) {
            this.rebuildAnonRoots();
        }
        return this.rootAnonymousNodes;
    }

    private void rebuildAnonRoots() {
        this.rootAnonymousNodes = new HashSet<RDFResourceBlankNode>();
        for (RDFTriple triple : this.triples) {
            if (!(triple.getSubject() instanceof RDFResourceBlankNode)) continue;
            this.rootAnonymousNodes.add((RDFResourceBlankNode)triple.getSubject());
        }
        for (RDFTriple triple : this.triples) {
            if (!triple.getObject().isLiteral()) {
                this.rootAnonymousNodes.remove(triple.getObject());
            }
            if (triple.getSubject().isAnonymous()) continue;
            this.rootAnonymousNodes.remove(triple.getSubject());
        }
    }

    public void dumpTriples(Writer w) throws IOException {
        for (Set<RDFTriple> set : this.triplesBySubject.values()) {
            for (RDFTriple triple : set) {
                w.write(triple.toString());
                w.write("\n");
            }
        }
        w.flush();
    }

    public Set<RDFTriple> getAllTriples() {
        return Collections.unmodifiableSet(this.triples);
    }
}

