/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxmlparser;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.coode.owlapi.owlxmlparser.OWLXMLParserHandler;
import org.coode.owlapi.owlxmlparser.TranslatedOWLParserException;
import org.coode.owlapi.owlxmlparser.TranslatedUnloadableImportException;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLXMLOntologyFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserSAXException;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        InputSource isrc = null;
        try {
            System.setProperty("entityExpansionLimit", "100000000");
            OWLXMLOntologyFormat format = new OWLXMLOntologyFormat();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            isrc = this.getInputSource(documentSource, configuration);
            OWLXMLParserHandler handler = new OWLXMLParserHandler(ontology, configuration);
            parser.parse(isrc, (DefaultHandler)handler);
            Map<String, String> prefix2NamespaceMap = handler.getPrefixName2PrefixMap();
            for (String prefix : prefix2NamespaceMap.keySet()) {
                format.setPrefix(prefix, prefix2NamespaceMap.get(prefix));
            }
            OWLXMLOntologyFormat oWLXMLOntologyFormat = format;
            return oWLXMLOntologyFormat;
        }
        catch (ParserConfigurationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        catch (TranslatedOWLParserException e) {
            throw e.getParserException();
        }
        catch (TranslatedUnloadableImportException e) {
            throw e.getUnloadableImportException();
        }
        catch (SAXException e) {
            throw new OWLParserSAXException(e);
        }
        finally {
            if (isrc != null && isrc.getByteStream() != null) {
                isrc.getByteStream().close();
            } else if (isrc != null && isrc.getCharacterStream() != null) {
                isrc.getCharacterStream().close();
            }
        }
    }

    public Set<OWLOntologyFormatFactory> getSupportedFormats() {
        HashSet<OWLOntologyFormatFactory> result = new HashSet<OWLOntologyFormatFactory>();
        result.add((OWLOntologyFormatFactory)new OWLXMLOntologyFormatFactory());
        return result;
    }
}

