/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.obo.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class SynonymTypeDefTagHandler
extends AbstractTagValueHandler {
    private static final Pattern PATTERN = Pattern.compile("([^\\s]*)\\s+\"([^\"]*)\"(\\s*([^\\s]*)\\s*)?");
    private static final int ID_GROUP = 1;
    private static final int NAME_GROUP = 2;

    public SynonymTypeDefTagHandler(OBOConsumer consumer) {
        super(OBOVocabulary.SYNONYM_TYPE_DEF.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches()) {
            String id = matcher.group(1);
            IRI annotationPropertyIRI = this.getIRIFromOBOId(id);
            String name = matcher.group(2);
            OWLDataFactory df = this.getDataFactory();
            OWLAnnotationProperty annotationProperty = df.getOWLAnnotationProperty(annotationPropertyIRI);
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)df.getOWLDeclarationAxiom((OWLEntity)annotationProperty)));
            IRI subsetdefIRI = this.getTagIRI(OBOVocabulary.SUBSETDEF.getName());
            OWLAnnotationProperty subsetdefAnnotationProperty = df.getOWLAnnotationProperty(subsetdefIRI);
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)df.getOWLSubAnnotationPropertyOfAxiom(annotationProperty, subsetdefAnnotationProperty)));
            OWLLiteral nameLiteral = df.getOWLLiteral(name);
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)df.getOWLAnnotationAssertionAxiom(df.getRDFSLabel(), (OWLAnnotationSubject)annotationPropertyIRI, (OWLAnnotationValue)nameLiteral)));
        } else {
            OWLAnnotation annotation = this.getAnnotationForTagValuePair(OBOVocabulary.SYNONYM_TYPE_DEF.getName(), value);
            this.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.getOntology(), annotation));
        }
    }
}

