/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coode.owlapi.obo.parser.OBOConsumer;
import org.coode.owlapi.obo.parser.OBOFrame;
import org.coode.owlapi.obo.parser.OBOOntologyFormat;
import org.coode.owlapi.obo.parser.OBOParser;
import org.coode.owlapi.obo.parser.OBOTagValuePair;
import org.coode.owlapi.obo.parser.ParseException;
import org.coode.owlapi.obo.parser.RawFrameHandler;
import org.coode.owlapi.obo.parser.Token;
import org.coode.owlapi.obo.parser.TokenMgrError;
import org.semanticweb.owlapi.formats.OBOOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OWLOBOParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        OBOParser parser;
        Reader reader = null;
        InputStream is = null;
        if (documentSource.isReaderAvailable()) {
            reader = documentSource.getReader();
            parser = new OBOParser(reader);
        } else if (documentSource.isInputStreamAvailable()) {
            is = documentSource.getInputStream();
            parser = new OBOParser(is);
        } else {
            is = this.getInputStream(documentSource.getDocumentIRI(), configuration);
            parser = new OBOParser(is);
        }
        RawFrameHandler rawFrameHandler = new RawFrameHandler();
        OBOConsumer oboConsumer = new OBOConsumer(ontology, configuration, documentSource.getDocumentIRI());
        parser.setHandler(rawFrameHandler);
        try {
            parser.parse();
            this.parseFrames(rawFrameHandler, oboConsumer);
        }
        catch (ParseException e) {
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyChangeException) {
                throw (OWLOntologyChangeException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof OWLOntologyAlreadyExistsException) {
                OWLOntologyAlreadyExistsException ex = (OWLOntologyAlreadyExistsException)e.getCause();
                throw new UnloadableImportException((OWLOntologyCreationException)ex, ontology.getOWLOntologyManager().getOWLDataFactory().getOWLImportsDeclaration(ex.getOntologyID().getOntologyIRI()));
            }
            Token currentToken = e.currentToken;
            if (currentToken != null) {
                int beginLine = currentToken.beginLine;
                int beginColumn = currentToken.beginColumn;
                throw new OWLParserException((Throwable)e, beginLine, beginColumn);
            }
            throw new OWLParserException((Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new OWLParserException((Throwable)((Object)e));
        }
        finally {
            if (is != null) {
                is.close();
            } else if (reader != null) {
                reader.close();
            }
        }
        OBOOntologyFormat format = new OBOOntologyFormat();
        format.setIDSpaceManager(oboConsumer.getIdSpaceManager());
        return format;
    }

    private void parseFrames(RawFrameHandler rawFrameHandler, OBOConsumer oboConsumer) {
        this.parseHeaderFrame(rawFrameHandler, oboConsumer);
        this.parseFrames(oboConsumer, rawFrameHandler.getTypeDefFrames());
        this.parseFrames(oboConsumer, rawFrameHandler.getNonTypeDefFrames());
    }

    private void parseHeaderFrame(RawFrameHandler rawFrameHandler, OBOConsumer consumer) {
        consumer.startHeader();
        this.parseFrameTagValuePairs(consumer, rawFrameHandler.getHeaderFrame());
        consumer.endHeader();
    }

    private void parseFrames(OBOConsumer oboConsumer, List<OBOFrame> frames) {
        for (OBOFrame frame : frames) {
            this.parseFrame(oboConsumer, frame);
        }
    }

    private void parseFrame(OBOConsumer oboConsumer, OBOFrame frame) {
        oboConsumer.startFrame(frame.getFrameType());
        this.parseFrameTagValuePairs(oboConsumer, frame);
        oboConsumer.endFrame();
    }

    private void parseFrameTagValuePairs(OBOConsumer oboConsumer, OBOFrame frame) {
        for (OBOTagValuePair tagValuePair : frame.getTagValuePairs()) {
            oboConsumer.handleTagValue(tagValuePair.getTagName(), tagValuePair.getValue(), tagValuePair.getQualifier(), tagValuePair.getComment());
        }
    }

    public Set<OWLOntologyFormatFactory> getSupportedFormats() {
        HashSet<OWLOntologyFormatFactory> result = new HashSet<OWLOntologyFormatFactory>();
        result.add((OWLOntologyFormatFactory)new OBOOntologyFormatFactory());
        return result;
    }
}

