/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.coode.owlapi.rdf.rdfxml.RDFXMLRenderer;
import org.coode.xml.IllegalElementNameException;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;

public class RDFXMLOntologyStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 30402L;

    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat instanceof RDFXMLOntologyFormat;
    }

    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, writer, format);
    }

    protected void storeOntology(OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        try {
            RDFXMLRenderer renderer = new RDFXMLRenderer(ontology, writer, format);
            Set<OWLEntity> entities = renderer.getUnserialisableEntities();
            if (!entities.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (OWLEntity entity : entities) {
                    sb.append(entity.toStringID());
                    sb.append("\n");
                }
                throw new OWLOntologyStorageException(sb.toString().trim(), (Throwable)((Object)new IllegalElementNameException(sb.toString().trim())));
            }
            renderer.render();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
        catch (IllegalElementNameException e) {
            throw new OWLOntologyStorageException((Throwable)((Object)e));
        }
    }
}

