/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.owlxml.renderer;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterFactory;
import org.coode.xml.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.OWLRendererIOException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;

public class OWLXMLWriter {
    private XMLWriter writer;
    private Map<String, String> iriPrefixMap = new TreeMap<String, String>(new StringLengthComparator());

    public OWLXMLWriter(Writer writer, OWLOntology ontology) {
        XMLWriterNamespaceManager nsm = new XMLWriterNamespaceManager(Namespaces.OWL.toString());
        nsm.setPrefix("xsd", Namespaces.XSD.toString());
        nsm.setPrefix("rdf", Namespaces.RDF.toString());
        nsm.setPrefix("rdfs", Namespaces.RDFS.toString());
        nsm.setPrefix("xml", Namespaces.XML.toString());
        String base = Namespaces.OWL.toString();
        if (ontology != null && !ontology.isAnonymous()) {
            base = ontology.getOntologyID().getOntologyIRI().toString();
        }
        this.writer = XMLWriterFactory.getInstance().createXMLWriter(writer, nsm, base);
    }

    public Map<String, String> getIRIPrefixMap() {
        return this.iriPrefixMap;
    }

    public XMLWriterNamespaceManager getNamespaceManager() {
        return this.writer.getNamespacePrefixes();
    }

    public void writePrefix(String prefixName, String iri) throws IOException {
        this.writer.writeStartElement(OWLXMLVocabulary.PREFIX.getIRI().toString());
        if (prefixName.endsWith(":")) {
            String attName = prefixName.substring(0, prefixName.length() - 1);
            this.writer.writeAttribute(OWLXMLVocabulary.NAME_ATTRIBUTE.getIRI().toString(), attName);
        } else {
            this.writer.writeAttribute(OWLXMLVocabulary.NAME_ATTRIBUTE.getIRI().toString(), prefixName);
        }
        this.writer.writeAttribute(OWLXMLVocabulary.IRI_ATTRIBUTE.getIRI().toString(), iri);
        this.writer.writeEndElement();
        this.iriPrefixMap.put(iri, prefixName);
    }

    public String getIRIString(URI iri) {
        String fullIRI = iri.toString();
        for (String prefixName : this.iriPrefixMap.keySet()) {
            if (!fullIRI.startsWith(prefixName)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(this.iriPrefixMap.get(prefixName));
            sb.append(fullIRI.substring(prefixName.length()));
            return sb.toString();
        }
        return fullIRI;
    }

    public void startDocument(OWLOntology ontology) throws OWLRendererException {
        try {
            this.writer.startDocument(OWLXMLVocabulary.ONTOLOGY.toString());
            if (!ontology.isAnonymous()) {
                this.writer.writeAttribute(Namespaces.OWL + "ontologyIRI", ontology.getOntologyID().getOntologyIRI().toString());
                if (ontology.getOntologyID().getVersionIRI() != null) {
                    this.writer.writeAttribute(Namespaces.OWL + "versionIRI", ontology.getOntologyID().getVersionIRI().toString());
                }
            }
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }

    public void endDocument() {
        try {
            this.writer.endDocument();
            this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeStartElement(OWLXMLVocabulary name) {
        try {
            this.writer.writeStartElement(name.getIRI().toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeEndElement() {
        try {
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeDatatypeAttribute(OWLDatatype datatype) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.DATATYPE_IRI.getIRI().toString(), datatype.getIRI().toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeNodeIDAttribute(NodeID nodeID) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.NODE_ID.getIRI().toString(), nodeID.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeIRIAttribute(IRI iri) {
        try {
            String attName = OWLXMLVocabulary.IRI_ATTRIBUTE.getIRI().toString();
            String value = iri.toString();
            if (value.startsWith(this.writer.getXMLBase())) {
                this.writer.writeAttribute(attName, value.substring(this.writer.getXMLBase().length(), value.length()));
            } else {
                String val = this.getIRIString(iri.toURI());
                if (!val.equals(iri.toString())) {
                    this.writer.writeAttribute(OWLXMLVocabulary.ABBREVIATED_IRI_ATTRIBUTE.getIRI().toString(), val);
                } else {
                    this.writer.writeAttribute(attName, val);
                }
            }
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeIRIElement(IRI iri) {
        try {
            String iriString = iri.toString();
            if (iriString.startsWith(this.writer.getXMLBase())) {
                this.writeStartElement(OWLXMLVocabulary.IRI_ELEMENT);
                this.writeTextContent(iriString.substring(this.writer.getXMLBase().length(), iriString.length()));
                this.writeEndElement();
            } else {
                String val = this.getIRIString(iri.toURI());
                if (!val.equals(iriString)) {
                    this.writeStartElement(OWLXMLVocabulary.ABBREVIATED_IRI_ELEMENT);
                    this.writer.writeTextContent(val);
                    this.writeEndElement();
                } else {
                    this.writeStartElement(OWLXMLVocabulary.IRI_ELEMENT);
                    this.writer.writeTextContent(val);
                    this.writeEndElement();
                }
            }
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeLangAttribute(String lang) {
        try {
            this.writer.writeAttribute(Namespaces.XML + "lang", lang);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeCardinalityAttribute(int cardinality) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.CARDINALITY_ATTRIBUTE.getIRI().toString(), Integer.toString(cardinality));
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeTextContent(String text) {
        try {
            this.writer.writeTextContent(text);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeFacetAttribute(OWLFacet facet) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.DATATYPE_FACET.getIRI().toString(), facet.getIRI().toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void writeAnnotationURIAttribute(URI uri) {
        try {
            this.writer.writeAttribute(OWLXMLVocabulary.ANNOTATION_URI.toString(), uri.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private static final class StringLengthComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 30402L;

        @Override
        public int compare(String o1, String o2) {
            int diff = o1.length() - o2.length();
            if (diff != 0) {
                return diff;
            }
            return o1.compareTo(o2);
        }
    }
}

