/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.latex;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.coode.owlapi.latex.LatexObjectVisitor;
import org.coode.owlapi.latex.LatexRendererIOException;
import org.coode.owlapi.latex.LatexWriter;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityComparator;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class LatexRenderer
extends AbstractOWLRenderer {
    private ShortFormProvider shortFormProvider = new SimpleShortFormProvider();

    @Deprecated
    public LatexRenderer(OWLOntologyManager owlOntologyManager) {
        this();
    }

    public LatexRenderer() {
    }

    private void writeEntitySection(OWLEntity entity, LatexWriter w) {
        w.write("\\subsubsection*{");
        w.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
        w.write("}\n\n");
    }

    private String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    public void render(OWLOntology ontology, Writer writer) throws OWLRendererException {
        try {
            LatexWriter w = new LatexWriter(writer);
            w.write("\\documentclass{article}\n");
            w.write("\\parskip 0pt\n");
            w.write("\\parindent 0pt\n");
            w.write("\\oddsidemargin 0cm\n");
            w.write("\\textwidth 19cm\n");
            w.write("\\begin{document}\n\n");
            LatexObjectVisitor renderer = new LatexObjectVisitor(w, ontology.getOWLOntologyManager().getOWLDataFactory());
            Collection clses = this.sortEntities(ontology.getClassesInSignature());
            if (!clses.isEmpty()) {
                w.write("\\subsection*{Classes}\n\n");
            }
            for (OWLClass cls : clses) {
                this.writeEntitySection((OWLEntity)cls, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(cls))) {
                    renderer.setSubject((OWLObject)cls);
                    ax.accept((OWLObjectVisitor)renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Object properties}");
            for (OWLObjectProperty prop : this.sortEntities(ontology.getObjectPropertiesInSignature())) {
                this.writeEntitySection((OWLEntity)prop, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms((OWLObjectPropertyExpression)prop))) {
                    ax.accept((OWLObjectVisitor)renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Data properties}");
            for (OWLObjectProperty prop : this.sortEntities(ontology.getDataPropertiesInSignature())) {
                this.writeEntitySection((OWLEntity)prop, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms((OWLDataProperty)prop))) {
                    ax.accept((OWLObjectVisitor)renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Individuals}");
            for (OWLNamedIndividual ind : this.sortEntities(ontology.getIndividualsInSignature())) {
                this.writeEntitySection((OWLEntity)ind, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms((OWLIndividual)ind))) {
                    ax.accept((OWLObjectVisitor)renderer);
                    w.write("\n\n");
                }
            }
            w.write("\\section*{Datatypes}");
            for (OWLDatatype type : this.sortEntities(ontology.getDatatypesInSignature())) {
                this.writeEntitySection((OWLEntity)type, w);
                for (OWLAxiom ax : this.sortAxioms(ontology.getAxioms(type))) {
                    ax.accept((OWLObjectVisitor)renderer);
                    w.write("\n\n");
                }
            }
            writer.write("\\end{document}\n");
            writer.flush();
        }
        catch (IOException e) {
            throw new LatexRendererIOException(e);
        }
    }

    private <T extends OWLEntity> Collection<T> sortEntities(Set<T> entites) {
        ArrayList<T> list = new ArrayList<T>(entites);
        OWLEntityComparator entityComparator = new OWLEntityComparator(this.shortFormProvider);
        Collections.sort(list, entityComparator);
        return list;
    }

    private Collection<OWLAxiom> sortAxioms(Set<? extends OWLAxiom> axioms) {
        ArrayList<OWLAxiom> list = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(list, new OWLAxiomComparator());
        return list;
    }

    private static class OWLAxiomComparator
    implements Comparator<OWLAxiom>,
    Serializable {
        private static final long serialVersionUID = 30402L;

        @Override
        public int compare(OWLAxiom o1, OWLAxiom o2) {
            int index1 = o1.getAxiomType().getIndex();
            int index2 = o2.getAxiomType().getIndex();
            return index1 - index2;
        }
    }
}

