/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.functionalparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.coode.owlapi.functionalparser.OWLFunctionalSyntaxParser;
import org.coode.owlapi.functionalparser.ParseException;
import org.semanticweb.owlapi.formats.OWLFunctionalSyntaxOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;

public class OWLFunctionalSyntaxOWLParser
extends AbstractOWLParser {
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, IOException, UnloadableImportException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        Reader reader = null;
        InputStream is = null;
        try {
            OWLFunctionalSyntaxParser parser;
            if (documentSource.isReaderAvailable()) {
                reader = documentSource.getReader();
                parser = new OWLFunctionalSyntaxParser(reader);
            } else if (documentSource.isInputStreamAvailable()) {
                is = documentSource.getInputStream();
                parser = new OWLFunctionalSyntaxParser(is);
            } else {
                is = this.getInputStream(documentSource.getDocumentIRI());
                parser = new OWLFunctionalSyntaxParser(is);
            }
            parser.setUp(ontology, configuration);
            OWLFunctionalSyntaxOntologyFormat oWLFunctionalSyntaxOntologyFormat = parser.parse();
            return oWLFunctionalSyntaxOntologyFormat;
        }
        catch (ParseException e) {
            throw new OWLParserException(e.getMessage(), (Throwable)e, e.currentToken.beginLine, e.currentToken.beginColumn);
        }
        finally {
            if (is != null) {
                is.close();
            } else if (reader != null) {
                reader.close();
            }
        }
    }

    public Set<OWLOntologyFormatFactory> getSupportedFormats() {
        HashSet<OWLOntologyFormatFactory> result = new HashSet<OWLOntologyFormatFactory>();
        result.add((OWLOntologyFormatFactory)new OWLFunctionalSyntaxOntologyFormatFactory());
        return result;
    }
}

