/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.OWLParserFactoryRegistry;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.AbstractInMemOWLOntologyFactory;

public class ParsableOWLOntologyFactory
extends AbstractInMemOWLOntologyFactory {
    private static final long serialVersionUID = 30406L;
    private static final Logger logger = LoggerFactory.getLogger(ParsableOWLOntologyFactory.class);
    private final Set<String> parsableSchemes;
    private OWLParserFactoryRegistry parserRegistry;

    public ParsableOWLOntologyFactory() {
        this(OWLParserFactoryRegistry.getInstance());
    }

    public ParsableOWLOntologyFactory(OWLParserFactoryRegistry nextParserRegistry) {
        this.parserRegistry = nextParserRegistry;
        this.parsableSchemes = new HashSet<String>();
        this.parsableSchemes.add("http");
        this.parsableSchemes.add("https");
        this.parsableSchemes.add("file");
        this.parsableSchemes.add("ftp");
    }

    public List<OWLParser> getParsers() {
        ArrayList<OWLParser> parsers = new ArrayList<OWLParser>();
        List factories = this.parserRegistry.getParserFactories();
        for (OWLParserFactory factory : factories) {
            OWLParser parser = factory.createParser(this.getOWLOntologyManager());
            parser.setOWLOntologyManager(this.getOWLOntologyManager());
            parsers.add(parser);
        }
        return parsers;
    }

    private List<OWLParser> getParsers(OWLOntologyDocumentSource documentSource) {
        OWLParserFactory parserFactory;
        List<Object> factories = documentSource.isFormatKnown() ? ((parserFactory = this.parserRegistry.getParserFactory(documentSource.getFormatFactory())) == null ? this.parserRegistry.getParserFactories() : Arrays.asList(parserFactory)) : this.parserRegistry.getParserFactories();
        ArrayList<OWLParser> parsers = new ArrayList<OWLParser>(factories.size());
        for (int i = 0; i < factories.size(); ++i) {
            OWLParser parser = factories.get(i).createParser(this.getOWLOntologyManager());
            parser.setOWLOntologyManager(this.getOWLOntologyManager());
            parsers.add(i, parser);
        }
        return parsers;
    }

    @Override
    public boolean canCreateFromDocumentIRI(IRI documentIRI) {
        return false;
    }

    @Deprecated
    public OWLOntology createOWLOntology(URI ontologyURI, URI physicalURI) {
        throw new OWLRuntimeException((Throwable)new UnsupportedOperationException("Cannot create new empty ontologies!"));
    }

    public boolean canLoad(OWLOntologyDocumentSource documentSource) {
        if (documentSource.isReaderAvailable()) {
            return true;
        }
        if (documentSource.isInputStreamAvailable()) {
            return true;
        }
        if (this.parsableSchemes.contains(documentSource.getDocumentIRI().getScheme())) {
            return true;
        }
        try {
            InputStream is = documentSource.getDocumentIRI().toURI().toURL().openStream();
            is.close();
            return true;
        }
        catch (UnknownHostException e) {
            logger.info("Unknown host: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.info("Malformed URL: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: " + e.getMessage());
        }
        catch (IOException e) {
            logger.info("IO Exception: " + e.getMessage());
        }
        return false;
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler mediator, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
        OWLOntology existingOntology = null;
        IRI iri = documentSource.getDocumentIRI();
        if (this.getOWLOntologyManager().contains(iri)) {
            existingOntology = this.getOWLOntologyManager().getOntology(iri);
        }
        OWLOntologyID ontologyID = new OWLOntologyID();
        OWLOntology ont = super.createOWLOntology(ontologyID, documentSource.getDocumentIRI(), mediator);
        for (OWLParser parser : this.getParsers(documentSource)) {
            try {
                if (existingOntology == null && !ont.isEmpty()) {
                    this.getOWLOntologyManager().removeOntology(ont);
                    ont = super.createOWLOntology(ontologyID, documentSource.getDocumentIRI(), mediator);
                }
                OWLOntologyFormat format = parser.parse(documentSource, ont, configuration);
                mediator.setOntologyFormat(ont, format);
                logger.debug("successfully loaded ontology using parser: {}", (Object)parser.toString());
                return ont;
            }
            catch (IOException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw new OWLOntologyCreationIOException(e);
            }
            catch (UnloadableImportException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw e;
            }
            catch (OWLParserException e) {
                logger.trace("found exception parsing ontology using parser " + parser.toString(), (Throwable)e);
                exceptions.put(parser, e);
            }
            catch (OWLOntologyChangeException e) {
                this.getOWLOntologyManager().removeOntology(ont);
                throw e;
            }
            catch (RuntimeException e) {
                if (parser.getClass().getName().startsWith("org.coode.owl.krssparser")) {
                    logger.trace("found error parsing ontology using krss parser " + parser.toString(), (Throwable)e);
                    exceptions.put(parser, new OWLParserException((Throwable)e));
                    continue;
                }
                this.getOWLOntologyManager().removeOntology(ont);
                throw new OWLOntologyCreationException((Throwable)e);
            }
            catch (Error e) {
                if (parser.getClass().getName().startsWith("org.coode.owl.krssparser")) {
                    logger.trace("found error parsing ontology using krss parser " + parser.toString(), (Throwable)e);
                    exceptions.put(parser, new OWLParserException((Throwable)e));
                    continue;
                }
                this.getOWLOntologyManager().removeOntology(ont);
                throw new OWLOntologyCreationException((Throwable)e);
            }
        }
        if (existingOntology == null) {
            this.getOWLOntologyManager().removeOntology(ont);
        }
        throw new UnparsableOntologyException(documentSource.getDocumentIRI(), exceptions, configuration);
    }

    public OWLOntology loadOWLOntology(OWLOntologyDocumentSource documentSource, OWLOntologyFactory.OWLOntologyCreationHandler mediator) throws OWLOntologyCreationException {
        return this.loadOWLOntology(documentSource, mediator, new OWLOntologyLoaderConfiguration());
    }
}

