/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    private static final long serialVersionUID = 30406L;
    private final OWLClassExpression subClass;
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(OWLClassExpression subClass, OWLClassExpression superClass, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = subClass;
        this.superClass = superClass;
    }

    @Deprecated
    public Set<OWLClassExpression> getClassExpressions() {
        HashSet<OWLClassExpression> classExpressions = new HashSet<OWLClassExpression>(3);
        classExpressions.add(this.subClass);
        classExpressions.add(this.superClass);
        return classExpressions;
    }

    @Deprecated
    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... desc) {
        Set<OWLClassExpression> classExpressions = this.getClassExpressions();
        for (OWLClassExpression ce : desc) {
            classExpressions.remove(ce);
        }
        return classExpressions;
    }

    public OWLSubClassOfAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, this.mergeAnnos(annotations));
    }

    public OWLSubClassOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    @Deprecated
    public boolean contains(OWLClassExpression ce) {
        return this.subClass.equals(ce) || this.superClass.equals(ce);
    }

    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLSubClassOfAxiom)) {
            return false;
        }
        if (super.equals(obj)) {
            OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)obj;
            return other.getSubClass().equals(this.subClass) && other.getSuperClass().equals(this.superClass);
        }
        return false;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLSubClassOfAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLSubClassOfAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubClassOfAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubClassOfAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SUBCLASS_OF;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubClassOfAxiom other = (OWLSubClassOfAxiom)object;
        int diff = this.subClass.compareTo((Object)other.getSubClass());
        if (diff != 0) {
            return diff;
        }
        return this.superClass.compareTo((Object)other.getSuperClass());
    }
}

