/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;

public class OWLDisjointUnionAxiomImpl
extends OWLClassAxiomImpl
implements OWLDisjointUnionAxiom {
    private static final long serialVersionUID = 30406L;
    private final OWLClass owlClass;
    private final Set<OWLClassExpression> classExpressions;

    public OWLDisjointUnionAxiomImpl(OWLClass owlClass, Set<? extends OWLClassExpression> classExpressions, Set<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.owlClass = owlClass;
        this.classExpressions = new TreeSet<OWLClassExpression>(classExpressions);
    }

    public Set<OWLClassExpression> getClassExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.classExpressions);
    }

    public OWLDisjointUnionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.getClassExpressions(), NO_ANNOTATIONS);
    }

    public OWLDisjointUnionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLDisjointUnionAxiomImpl(this.getOWLClass(), this.getClassExpressions(), this.mergeAnnos(annotations));
    }

    public OWLClass getOWLClass() {
        return this.owlClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLDisjointUnionAxiom)) {
                return false;
            }
            return ((OWLDisjointUnionAxiom)obj).getOWLClass().equals(this.owlClass);
        }
        return false;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLDisjointUnionAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDisjointUnionAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDisjointUnionAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDisjointUnionAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.DISJOINT_UNION;
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom() {
        return new OWLEquivalentClassesAxiomImpl(new HashSet<OWLClassExpression>(Arrays.asList(this.owlClass, new OWLObjectUnionOfImpl(this.getClassExpressions()))), NO_ANNOTATIONS);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom() {
        return new OWLDisjointClassesAxiomImpl(this.getClassExpressions(), NO_ANNOTATIONS);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDisjointUnionAxiom other = (OWLDisjointUnionAxiom)object;
        int diff = this.owlClass.compareTo((Object)other.getOWLClass());
        if (diff != 0) {
            return diff;
        }
        return OWLDisjointUnionAxiomImpl.compareSets(this.classExpressions, other.getClassExpressions());
    }
}

