/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.apibinding;

import java.util.List;
import org.semanticweb.owlapi.io.OWLParserFactoryRegistry;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLOntologyStorer;
import org.semanticweb.owlapi.model.OWLOntologyStorerFactory;
import org.semanticweb.owlapi.model.OWLOntologyStorerFactoryRegistry;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.EmptyInMemOWLOntologyFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl;
import uk.ac.manchester.cs.owl.owlapi.ParsableOWLOntologyFactory;

public class OWLManager
implements OWLOntologyManagerFactory {
    private static final Logger logger = LoggerFactory.getLogger(OWLManager.class);

    public OWLOntologyManager buildOWLOntologyManager() {
        return OWLManager.createOWLOntologyManager(this.getFactory());
    }

    public OWLOntologyManager buildOWLOntologyManager(OWLDataFactory f) {
        return OWLManager.createOWLOntologyManager(f);
    }

    public OWLOntologyManager buildOWLOntologyManager(OWLDataFactory f, OWLOntologyStorerFactoryRegistry storerRegistry, OWLParserFactoryRegistry parserRegistry) {
        return OWLManager.createOWLOntologyManager(f, storerRegistry, parserRegistry);
    }

    public OWLDataFactory getFactory() {
        return OWLManager.getOWLDataFactory();
    }

    public static OWLOntologyManager createOWLOntologyManager() {
        return OWLManager.createOWLOntologyManager(OWLManager.getOWLDataFactory());
    }

    public static OWLOntologyManager createOWLOntologyManager(OWLDataFactory dataFactory) {
        return OWLManager.createOWLOntologyManager(dataFactory, OWLOntologyStorerFactoryRegistry.getInstance(), OWLParserFactoryRegistry.getInstance());
    }

    public static OWLOntologyManager createOWLOntologyManager(OWLDataFactory dataFactory, OWLOntologyStorerFactoryRegistry storerRegistry, OWLParserFactoryRegistry parserRegistry) {
        OWLOntologyManagerImpl ontologyManager = new OWLOntologyManagerImpl(dataFactory);
        List allFactories = storerRegistry.getStorerFactories();
        if (logger.isDebugEnabled()) {
            logger.debug("Found {} ontology storer factories", (Object)allFactories.size());
        }
        OWLManager.addOntologyStorers(ontologyManager, allFactories);
        ontologyManager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
        ontologyManager.addOntologyFactory(new EmptyInMemOWLOntologyFactory());
        ontologyManager.addOntologyFactory(new ParsableOWLOntologyFactory(parserRegistry));
        return ontologyManager;
    }

    private static void addOntologyStorers(OWLOntologyManager ontologyManager, List<OWLOntologyStorerFactory> storerFactories) {
        if (storerFactories != null) {
            for (OWLOntologyStorerFactory nextFactory : storerFactories) {
                OWLOntologyStorer createdStorer = nextFactory.createStorer();
                if (logger.isDebugEnabled()) {
                    logger.debug("Created a new ontology storer {}", (Object)createdStorer.toString());
                }
                ontologyManager.addOntologyStorer(createdStorer);
            }
        }
    }

    public static OWLDataFactory getOWLDataFactory() {
        return new OWLDataFactoryImpl();
    }
}

