/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImpl;

public class OWLSubPropertyChainAxiomImpl
extends OWLPropertyAxiomImpl
implements OWLSubPropertyChainOfAxiom {
    private static final long serialVersionUID = 30402L;
    private final List<OWLObjectPropertyExpression> propertyChain;
    private final OWLObjectPropertyExpression superProperty;

    public OWLSubPropertyChainAxiomImpl(List<? extends OWLObjectPropertyExpression> propertyChain, OWLObjectPropertyExpression superProperty, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.propertyChain = new ArrayList<OWLObjectPropertyExpression>(propertyChain);
        this.superProperty = superProperty;
    }

    public OWLSubPropertyChainOfAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return OWLSubPropertyChainAxiomImpl.getOWLDataFactory().getOWLSubPropertyChainOfAxiom(this.getPropertyChain(), this.getSuperProperty(), this.mergeAnnos(annotations));
    }

    public OWLSubPropertyChainOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return OWLSubPropertyChainAxiomImpl.getOWLDataFactory().getOWLSubPropertyChainOfAxiom(this.getPropertyChain(), this.getSuperProperty());
    }

    public List<OWLObjectPropertyExpression> getPropertyChain() {
        return new ArrayList<OWLObjectPropertyExpression>(this.propertyChain);
    }

    public OWLObjectPropertyExpression getSuperProperty() {
        return this.superProperty;
    }

    public boolean isEncodingOfTransitiveProperty() {
        if (this.propertyChain.size() == 2) {
            return this.superProperty.equals(this.propertyChain.get(0)) && this.superProperty.equals(this.propertyChain.get(1));
        }
        return false;
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLSubPropertyChainOfAxiom)this);
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLSubPropertyChainOfAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubPropertyChainOfAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSubPropertyChainOfAxiom)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLSubPropertyChainOfAxiom)) {
            return false;
        }
        OWLSubPropertyChainOfAxiom other = (OWLSubPropertyChainOfAxiom)obj;
        return other.getPropertyChain().equals(this.getPropertyChain()) && other.getSuperProperty().equals(this.superProperty);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SUB_PROPERTY_CHAIN_OF;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubPropertyChainOfAxiom other = (OWLSubPropertyChainOfAxiom)object;
        for (int i = 0; i < this.propertyChain.size() && i < other.getPropertyChain().size(); ++i) {
            int diff = this.propertyChain.get(i).compareTo(other.getPropertyChain().get(i));
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        int diff = this.propertyChain.size() - other.getPropertyChain().size();
        if (diff != 0) {
            return diff;
        }
        return this.superProperty.compareTo((Object)other.getSuperProperty());
    }
}

