/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNaryIndividualAxiomImpl;

public class OWLSameIndividualAxiomImpl
extends OWLNaryIndividualAxiomImpl
implements OWLSameIndividualAxiom {
    private static final long serialVersionUID = 30402L;

    public OWLSameIndividualAxiomImpl(Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        super(individuals, annotations);
    }

    public OWLSameIndividualAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLSameIndividualAxiom(this.getIndividuals());
    }

    public OWLSameIndividualAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLSameIndividualAxiom(this.getIndividuals(), this.mergeAnnos(annotations));
    }

    public Set<OWLSameIndividualAxiom> asPairwiseAxioms() {
        List<OWLIndividual> inds = this.getIndividualsAsList();
        HashSet<OWLSameIndividualAxiom> result = new HashSet<OWLSameIndividualAxiom>();
        for (int i = 0; i < inds.size() - 1; ++i) {
            OWLIndividual indI = inds.get(i);
            OWLIndividual indJ = inds.get(i + 1);
            result.add(OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLSameIndividualAxiom(new OWLIndividual[]{indI, indJ}));
        }
        return result;
    }

    public boolean containsAnonymousIndividuals() {
        for (OWLIndividual ind : this.getIndividuals()) {
            if (!ind.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public Set<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
        ArrayList<OWLObjectOneOf> nominalsList = new ArrayList<OWLObjectOneOf>();
        for (OWLIndividual individual : this.getIndividuals()) {
            nominalsList.add(OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLObjectOneOf(new OWLIndividual[]{individual}));
        }
        HashSet<OWLSubClassOfAxiom> result = new HashSet<OWLSubClassOfAxiom>();
        for (int i = 0; i < nominalsList.size() - 1; ++i) {
            OWLClassExpression ceI = (OWLClassExpression)nominalsList.get(i);
            OWLClassExpression ceJ = (OWLClassExpression)nominalsList.get(i + 1);
            result.add(OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLSubClassOfAxiom(ceI, ceJ));
            result.add(OWLSameIndividualAxiomImpl.getOWLDataFactory().getOWLSubClassOfAxiom(ceJ, ceI));
        }
        return result;
    }

    @Deprecated
    public Set<OWLSameIndividualAxiom> asPairwiseSameIndividualAxioms() {
        return this.asPairwiseAxioms();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLSameIndividualAxiom;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLSameIndividualAxiom)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLSameIndividualAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSameIndividualAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLSameIndividualAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.SAME_INDIVIDUAL;
    }
}

