/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.util.ObjectPropertySimplifier;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyExpressionImpl;

public abstract class OWLObjectPropertyExpressionImpl
extends OWLPropertyExpressionImpl<OWLClassExpression, OWLObjectPropertyExpression>
implements OWLObjectPropertyExpression {
    private static final long serialVersionUID = 30402L;
    private OWLObjectPropertyExpression simplestForm;
    private OWLObjectPropertyExpression inverse;

    @Override
    protected Set<? extends OWLPropertyDomainAxiom<?>> getDomainAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyDomainAxioms((OWLObjectPropertyExpression)this);
    }

    public boolean isObjectPropertyExpression() {
        return true;
    }

    public boolean isDataPropertyExpression() {
        return false;
    }

    public boolean isFunctional(OWLOntology ontology) {
        return ontology.getFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)this).size() > 0;
    }

    public boolean isFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isInverseFunctional(OWLOntology ontology) {
        return !ontology.getInverseFunctionalObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isInverseFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isInverseFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isSymmetric(OWLOntology ontology) {
        return !ontology.getSymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isSymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isSymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsymmetric(OWLOntology ontology) {
        return !ontology.getAsymmetricObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isAsymmetric(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isAsymmetric(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isReflexive(OWLOntology ontology) {
        return !ontology.getReflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isReflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isReflexive(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isIrreflexive(OWLOntology ontology) {
        return !ontology.getIrreflexiveObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isIrreflexive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isIrreflexive(ont)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransitive(OWLOntology ontology) {
        return !ontology.getTransitiveObjectPropertyAxioms((OWLObjectPropertyExpression)this).isEmpty();
    }

    public boolean isTransitive(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isTransitive(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<? extends OWLPropertyRangeAxiom<OWLObjectPropertyExpression, OWLClassExpression>> getRangeAxioms(OWLOntology ontology) {
        return ontology.getObjectPropertyRangeAxioms((OWLObjectPropertyExpression)this);
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLObjectPropertyExpression>> getSubPropertyAxioms(OWLOntology ontology) {
        return ontology.getObjectSubPropertyAxiomsForSubProperty((OWLObjectPropertyExpression)this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getEquivalentPropertiesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>> getDisjointPropertiesAxioms(OWLOntology ontology) {
        return ontology.getDisjointObjectPropertiesAxioms((OWLObjectPropertyExpression)this);
    }

    public Set<OWLObjectPropertyExpression> getInverses(OWLOntology ontology) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLInverseObjectPropertiesAxiom ax : ontology.getInverseObjectPropertyAxioms((OWLObjectPropertyExpression)this)) {
            if (ax.getFirstProperty().equals(this)) {
                result.add(ax.getSecondProperty());
                continue;
            }
            result.add(ax.getFirstProperty());
        }
        return result;
    }

    public Set<OWLObjectPropertyExpression> getInverses(Set<OWLOntology> ontologies) {
        TreeSet<OWLObjectPropertyExpression> result = new TreeSet<OWLObjectPropertyExpression>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getInverses(ont));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof OWLObjectPropertyExpression;
    }

    public OWLObjectPropertyExpression getSimplified() {
        if (this.simplestForm == null) {
            ObjectPropertySimplifier simplifier = new ObjectPropertySimplifier(OWLObjectPropertyExpressionImpl.getOWLDataFactory());
            this.simplestForm = simplifier.getSimplified((OWLObjectPropertyExpression)this);
        }
        return this.simplestForm;
    }

    public OWLObjectPropertyExpression getInverseProperty() {
        if (this.inverse == null) {
            this.inverse = OWLObjectPropertyExpressionImpl.getOWLDataFactory().getOWLObjectInverseOf((OWLObjectPropertyExpression)this);
        }
        return this.inverse;
    }

    public OWLObjectProperty getNamedProperty() {
        OWLObjectPropertyExpression simp = this.getSimplified();
        if (simp.isAnonymous()) {
            return ((OWLObjectInverseOf)simp).getInverse().asOWLObjectProperty();
        }
        return simp.asOWLObjectProperty();
    }
}

