/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.ImplUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyExpressionImpl;

public class OWLDataPropertyImpl
extends OWLPropertyExpressionImpl<OWLDataRange, OWLDataPropertyExpression>
implements OWLDataProperty {
    private static final long serialVersionUID = 30402L;
    private final IRI iri;
    private final boolean builtin;

    public OWLDataPropertyImpl(IRI iri) {
        this.iri = iri;
        this.builtin = iri.equals((Object)OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLTopDataProperty();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLBottomDataProperty();
    }

    public EntityType<?> getEntityType() {
        return EntityType.DATA_PROPERTY;
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType) {
        return (E)OWLDataPropertyImpl.getOWLDataFactory().getOWLEntity(entityType, this.iri);
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public boolean isDataPropertyExpression() {
        return true;
    }

    public boolean isObjectPropertyExpression() {
        return false;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    public boolean isFunctional(OWLOntology ontology) {
        return ontology.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)this).size() > 0;
    }

    public boolean isFunctional(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isFunctional(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLDataPropertyExpression>> getDisjointPropertiesAxioms(OWLOntology ontology) {
        return ontology.getDisjointDataPropertiesAxioms((OWLDataProperty)this);
    }

    @Override
    protected Set<? extends OWLPropertyDomainAxiom<?>> getDomainAxioms(OWLOntology ontology) {
        return ontology.getDataPropertyDomainAxioms((OWLDataProperty)this);
    }

    @Override
    protected Set<? extends OWLPropertyRangeAxiom<OWLDataPropertyExpression, OWLDataRange>> getRangeAxioms(OWLOntology ontology) {
        return ontology.getDataPropertyRangeAxioms((OWLDataProperty)this);
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLDataPropertyExpression>> getSubPropertyAxioms(OWLOntology ontology) {
        return ontology.getDataSubPropertyAxiomsForSubProperty((OWLDataProperty)this);
    }

    @Override
    protected Set<? extends OWLNaryPropertyAxiom<OWLDataPropertyExpression>> getEquivalentPropertiesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentDataPropertiesAxioms((OWLDataProperty)this);
    }

    @Override
    protected Set<? extends OWLSubPropertyAxiom<OWLDataPropertyExpression>> getSubPropertyAxiomsForRHS(OWLOntology ont) {
        return ont.getDataSubPropertyAxiomsForSuperProperty((OWLDataPropertyExpression)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLDataProperty)) {
                return false;
            }
            IRI otherIRI = ((OWLDataProperty)obj).getIRI();
            return otherIRI.equals((Object)this.iri);
        }
        return false;
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms((OWLEntity)this, Collections.singleton(ontology));
    }

    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, OWLAnnotationProperty annotationProperty) {
        return ImplUtils.getAnnotations((OWLEntity)this, annotationProperty, Collections.singleton(ontology));
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLPropertyExpressionVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLPropertyExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDataProperty)this);
    }

    public boolean isAnonymous() {
        return false;
    }

    public OWLDataProperty asOWLDataProperty() {
        return this;
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not an OWLDatatype!");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an OWLIndividual!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an OWLObjectProperty!");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return true;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public boolean isOWLTopObjectProperty() {
        return false;
    }

    public boolean isOWLBottomObjectProperty() {
        return false;
    }

    public boolean isOWLTopDataProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
    }

    public boolean isOWLBottomDataProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology) {
        return ontology.getReferencingAxioms((OWLEntity)this);
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLOntology ontology, boolean includeImports) {
        return ontology.getReferencingAxioms((OWLEntity)this, includeImports);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLDataProperty)object).getIRI());
    }
}

