/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.InternalsNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAsymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAssertionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeDefinitionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDeclarationAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDifferentIndividualsAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointUnionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFacetRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalDataPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLHasKeyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLIrreflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeDataPropertyAssertionImplAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasSelfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLReflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSameIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubAnnotationPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubDataPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubObjectPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubPropertyChainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLTransitiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLBuiltInAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLClassAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataRangeAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDifferentIndividualsAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLIndividualArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLLiteralArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLObjectPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLRuleImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLSameIndividualAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLVariableImpl;

public class OWLDataFactoryImpl
implements OWLDataFactory,
Serializable {
    private static final long serialVersionUID = 30402L;
    private static final String ABBREVIATED_IRI = "abbreviatedIRI";
    private static final String ID2 = "id";
    private static final String CURI2 = "curi";
    private static final String PREFIX_MANAGER = "prefixManager";
    private static final String IRI2 = "iri";
    private static final String VALUE2 = "value";
    private static final String DATATYPE2 = "datatype";
    private static final String LITERAL2 = "literal";
    private static final String VALUES2 = "values";
    private static final String DATA_RANGES = "dataRanges";
    private static final String DATA_RANGE = "dataRange";
    private static final OWLDataFactory instance = new OWLDataFactoryImpl(false, false);
    private static final OWLClass OWL_THING = new OWLClassImpl(OWLRDFVocabulary.OWL_THING.getIRI());
    private static final OWLClass OWL_NOTHING = new OWLClassImpl(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    private static final OWLAnnotationProperty RDFS_LABEL = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_LABEL.getIRI());
    private static final OWLAnnotationProperty RDFS_COMMENT = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    private static final OWLAnnotationProperty RDFS_SEE_ALSO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_SEE_ALSO.getIRI());
    private static final OWLAnnotationProperty RDFS_IS_DEFINED_BY = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_IS_DEFINED_BY.getIRI());
    private static final OWLAnnotationProperty OWL_BACKWARD_COMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI());
    private static final OWLAnnotationProperty OWL_INCOMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI());
    private static final OWLAnnotationProperty OWL_VERSION_INFO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
    private static final OWLAnnotationProperty OWL_DEPRECATED = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
    private static final OWLObjectProperty OWL_TOP_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
    private static final OWLObjectProperty OWL_BOTTOM_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    private static final OWLDataProperty OWL_TOP_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
    private static final OWLDataProperty OWL_BOTTOM_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    protected OWLDataFactoryInternals data;
    private static final Set<OWLAnnotation> EMPTY_ANNOTATIONS_SET = Collections.emptySet();

    public OWLDataFactoryImpl() {
        this(true, false);
    }

    public OWLDataFactoryImpl(boolean cache, boolean useCompression) {
        this.data = cache ? new OWLDataFactoryInternalsImpl(this, useCompression) : new InternalsNoCache(this, useCompression);
    }

    @Deprecated
    public static OWLDataFactory getInstance() {
        System.err.println("OWLDataFactoryImpl.getInstance() WARNING: you should not use the implementation directly; this static method is here for backwards compatibility only");
        return instance;
    }

    public void purge() {
        this.data.purge();
    }

    private void checkNull(Object o, String name) {
        if (o == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (o instanceof Iterable) {
            int i = 0;
            for (Object t : (Iterable)o) {
                if (t == null) {
                    throw new IllegalArgumentException(name + " element " + i + " cannot be null");
                }
                ++i;
            }
        }
    }

    public <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType, IRI iri) {
        this.checkNull(entityType, "entityType");
        this.checkNull(iri, IRI2);
        OWLClass ret = null;
        if (entityType.equals((Object)EntityType.CLASS)) {
            ret = this.getOWLClass(iri);
        } else if (entityType.equals((Object)EntityType.OBJECT_PROPERTY)) {
            ret = this.getOWLObjectProperty(iri);
        } else if (entityType.equals((Object)EntityType.DATA_PROPERTY)) {
            ret = this.getOWLDataProperty(iri);
        } else if (entityType.equals((Object)EntityType.ANNOTATION_PROPERTY)) {
            ret = this.getOWLAnnotationProperty(iri);
        } else if (entityType.equals((Object)EntityType.NAMED_INDIVIDUAL)) {
            ret = this.getOWLNamedIndividual(iri);
        } else if (entityType.equals((Object)EntityType.DATATYPE)) {
            ret = this.getOWLDatatype(iri);
        }
        return (E)ret;
    }

    public OWLClass getOWLClass(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLClass(iri);
    }

    public OWLClass getOWLClass(String iri, PrefixManager prefixManager) {
        this.checkNull(iri, IRI2);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.getOWLClass(prefixManager.getIRI(iri));
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(String abbreviatedIRI, PrefixManager prefixManager) {
        this.checkNull(abbreviatedIRI, ABBREVIATED_IRI);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.getOWLAnnotationProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    public OWLAnnotationProperty getRDFSLabel() {
        return RDFS_LABEL;
    }

    public OWLAnnotationProperty getRDFSComment() {
        return RDFS_COMMENT;
    }

    public OWLAnnotationProperty getRDFSSeeAlso() {
        return RDFS_SEE_ALSO;
    }

    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return RDFS_IS_DEFINED_BY;
    }

    public OWLAnnotationProperty getOWLVersionInfo() {
        return OWL_VERSION_INFO;
    }

    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return OWL_BACKWARD_COMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return OWL_INCOMPATIBLE_WITH;
    }

    public OWLAnnotationProperty getOWLDeprecated() {
        return OWL_DEPRECATED;
    }

    public OWLDatatype getOWLDatatype(String abbreviatedIRI, PrefixManager prefixManager) {
        this.checkNull(abbreviatedIRI, ABBREVIATED_IRI);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.data.getOWLDatatype(prefixManager.getIRI(abbreviatedIRI));
    }

    public OWLClass getOWLThing() {
        return OWL_THING;
    }

    public OWLClass getOWLNothing() {
        return OWL_NOTHING;
    }

    public OWLDataProperty getOWLBottomDataProperty() {
        return OWL_BOTTOM_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLBottomObjectProperty() {
        return OWL_BOTTOM_OBJECT_PROPERTY;
    }

    public OWLDataProperty getOWLTopDataProperty() {
        return OWL_TOP_DATA_PROPERTY;
    }

    public OWLObjectProperty getOWLTopObjectProperty() {
        return OWL_TOP_OBJECT_PROPERTY;
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLObjectProperty(iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLDataProperty(iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLNamedIndividual(iri);
    }

    public OWLDataProperty getOWLDataProperty(String curi, PrefixManager prefixManager) {
        this.checkNull(curi, CURI2);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.getOWLDataProperty(prefixManager.getIRI(curi));
    }

    public OWLNamedIndividual getOWLNamedIndividual(String curi, PrefixManager prefixManager) {
        this.checkNull(curi, CURI2);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.getOWLNamedIndividual(prefixManager.getIRI(curi));
    }

    public OWLObjectProperty getOWLObjectProperty(String curi, PrefixManager prefixManager) {
        this.checkNull(curi, CURI2);
        this.checkNull(prefixManager, PREFIX_MANAGER);
        return this.getOWLObjectProperty(prefixManager.getIRI(curi));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual(String id) {
        this.checkNull(id, ID2);
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID((String)id));
    }

    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID(null));
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLDatatype(iri);
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWL2Datatype datatype) {
        this.checkNull(lexicalValue, "lexicalValue");
        this.checkNull(datatype, DATATYPE2);
        return this.getOWLLiteral(lexicalValue, OWL2DatatypeImpl.getDatatype(datatype));
    }

    public OWLLiteral getOWLLiteral(boolean value) {
        return this.data.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(String literal, OWLDatatype datatype) {
        this.checkNull(literal, LITERAL2);
        this.checkNull(datatype, DATATYPE2);
        return this.getOWLLiteral(literal, datatype);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(String literal, OWL2Datatype datatype) {
        this.checkNull(literal, LITERAL2);
        this.checkNull(datatype, DATATYPE2);
        return this.getOWLLiteral(literal, datatype);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(int value) {
        return this.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(double value) {
        return this.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(boolean value) {
        return this.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(float value) {
        return this.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLTypedLiteral(String value) {
        return this.getOWLLiteral(value);
    }

    @Deprecated
    public OWLLiteral getOWLStringLiteral(String literal, String lang) {
        return this.getOWLLiteral(literal, lang);
    }

    @Deprecated
    public OWLLiteral getOWLStringLiteral(String literal) {
        return this.getOWLLiteral(literal, "");
    }

    public OWLDataOneOf getOWLDataOneOf(Set<? extends OWLLiteral> values) {
        this.checkNull(values, VALUES2);
        return new OWLDataOneOfImpl(values);
    }

    public OWLDataOneOf getOWLDataOneOf(OWLLiteral ... values) {
        this.checkNull(values, VALUES2);
        return this.getOWLDataOneOf(CollectionFactory.createSet((Object[])values));
    }

    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange dataRange) {
        this.checkNull(dataRange, DATA_RANGE);
        return new OWLDataComplementOfImpl(dataRange);
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(OWLDataRange ... dataRanges) {
        this.checkNull(dataRanges, DATA_RANGES);
        return this.getOWLDataIntersectionOf(CollectionFactory.createSet((Object[])dataRanges));
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(Set<? extends OWLDataRange> dataRanges) {
        this.checkNull(dataRanges, DATA_RANGES);
        return new OWLDataIntersectionOfImpl(dataRanges);
    }

    public OWLDataUnionOf getOWLDataUnionOf(OWLDataRange ... dataRanges) {
        this.checkNull(dataRanges, DATA_RANGES);
        return this.getOWLDataUnionOf(CollectionFactory.createSet((Object[])dataRanges));
    }

    public OWLDataUnionOf getOWLDataUnionOf(Set<? extends OWLDataRange> dataRanges) {
        this.checkNull(dataRanges, DATA_RANGES);
        return new OWLDataUnionOfImpl(dataRanges);
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype datatype, Set<OWLFacetRestriction> facets) {
        this.checkNull(datatype, DATATYPE2);
        this.checkNull(facets, "facets");
        return new OWLDatatypeRestrictionImpl(datatype, facets);
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype datatype, OWLFacet facet, OWLLiteral typedConstant) {
        this.checkNull(datatype, DATATYPE2);
        this.checkNull(facet, "facet");
        this.checkNull(typedConstant, "typedConstant");
        return new OWLDatatypeRestrictionImpl(datatype, Collections.singleton(this.getOWLFacetRestriction(facet, typedConstant)));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataRange, OWLFacetRestriction ... facetRestrictions) {
        this.checkNull(facetRestrictions, "facetRestrictions");
        return this.getOWLDatatypeRestriction(dataRange, CollectionFactory.createSet((Object[])facetRestrictions));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(int minInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(int minInclusive, int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(int minExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(int minExclusive, int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(double minInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(double minInclusive, double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(double minExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(double minExclusive, double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, int facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, double facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, float facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        this.checkNull(facet, "facet");
        this.checkNull(facetValue, "facetValue");
        return new OWLFacetRestrictionImpl(facet, facetValue);
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(Set<? extends OWLClassExpression> operands) {
        this.checkNull(operands, "operands");
        return new OWLObjectIntersectionOfImpl(operands);
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(OWLClassExpression ... operands) {
        this.checkNull(operands, "operands");
        return this.getOWLObjectIntersectionOf(CollectionFactory.createSet((Object[])operands));
    }

    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        this.checkNull(dataRange, DATA_RANGE);
        this.checkNull(property, "property");
        return new OWLDataAllValuesFromImpl(property, dataRange);
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLDataExactCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        this.checkNull(dataRange, DATA_RANGE);
        this.checkNull(property, "property");
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        return new OWLDataExactCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLDataMaxCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        this.checkNull(dataRange, DATA_RANGE);
        return new OWLDataMaxCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLDataMinCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        this.checkNull(dataRange, DATA_RANGE);
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLDataMinCardinalityImpl(property, cardinality, dataRange);
    }

    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        this.checkNull(dataRange, DATA_RANGE);
        this.checkNull(property, "property");
        return new OWLDataSomeValuesFromImpl(property, dataRange);
    }

    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        this.checkNull(property, "property");
        this.checkNull(value, VALUE2);
        return new OWLDataHasValueImpl(property, value);
    }

    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        this.checkNull(operand, "operand");
        return new OWLObjectComplementOfImpl(operand);
    }

    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        this.checkNull(classExpression, "classExpression");
        this.checkNull(property, "property");
        return new OWLObjectAllValuesFromImpl(property, classExpression);
    }

    public OWLObjectOneOf getOWLObjectOneOf(Set<? extends OWLIndividual> values) {
        this.checkNull(values, VALUES2);
        return new OWLObjectOneOfImpl(values);
    }

    public OWLObjectOneOf getOWLObjectOneOf(OWLIndividual ... individuals) {
        this.checkNull(individuals, "individuals");
        return this.getOWLObjectOneOf(CollectionFactory.createSet((Object[])individuals));
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLObjectExactCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        this.checkNull(classExpression, "classExpression");
        this.checkNull(property, "property");
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        return new OWLObjectExactCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLObjectMinCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        this.checkNull(classExpression, "classExpression");
        this.checkNull(property, "property");
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        return new OWLObjectMinCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(property, "property");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        if (cardinality < 0) {
            throw new IllegalArgumentException("cardinality cannot be negative");
        }
        this.checkNull(classExpression, "classExpression");
        this.checkNull(property, "property");
        return new OWLObjectMaxCardinalityImpl(property, cardinality, classExpression);
    }

    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        this.checkNull(property, "property");
        return new OWLObjectHasSelfImpl(property);
    }

    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        this.checkNull(classExpression, "classExpression");
        this.checkNull(property, "property");
        return new OWLObjectSomeValuesFromImpl(property, classExpression);
    }

    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        this.checkNull(property, "property");
        this.checkNull(individual, "individual");
        return new OWLObjectHasValueImpl(property, individual);
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(Set<? extends OWLClassExpression> operands) {
        this.checkNull(operands, "operands");
        return new OWLObjectUnionOfImpl(operands);
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(OWLClassExpression ... operands) {
        this.checkNull(operands, "operands");
        return this.getOWLObjectUnionOf(CollectionFactory.createSet((Object[])operands));
    }

    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(propertyExpression, "propertyExpression");
        this.checkNull(annotations, "annotations");
        return new OWLAsymmetricObjectPropertyAxiomImpl(propertyExpression, annotations);
    }

    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression) {
        return this.getOWLAsymmetricObjectPropertyAxiom(propertyExpression, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(domain, "domain");
        this.checkNull(annotations, "annotations");
        return new OWLDataPropertyDomainAxiomImpl(property, domain, annotations);
    }

    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain) {
        return this.getOWLDataPropertyDomainAxiom(property, domain, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(owlDataRange, "owlDataRange");
        this.checkNull(annotations, "annotations");
        return new OWLDataPropertyRangeAxiomImpl(property, owlDataRange, annotations);
    }

    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange) {
        return this.getOWLDataPropertyRangeAxiom(property, owlDataRange, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(subProperty, "subProperty");
        this.checkNull(superProperty, "superProperty");
        this.checkNull(annotations, "annotations");
        return new OWLSubDataPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty) {
        return this.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity) {
        return this.getOWLDeclarationAxiom(owlEntity, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(owlEntity, "owlEntity");
        this.checkNull(annotations, "annotations");
        return new OWLDeclarationAxiomImpl(owlEntity, annotations);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(individuals, "individuals");
        this.checkNull(annotations, "annotations");
        return new OWLDifferentIndividualsAxiomImpl(individuals, annotations);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(OWLIndividual ... individuals) {
        this.checkNull(individuals, "individuals");
        return this.getOWLDifferentIndividualsAxiom(CollectionFactory.createSet((Object[])individuals));
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(Set<? extends OWLIndividual> individuals) {
        return this.getOWLDifferentIndividualsAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Set<? extends OWLClassExpression> classExpressions, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(classExpressions, "classExpressions");
        this.checkNull(annotations, "annotations");
        return new OWLDisjointClassesAxiomImpl(classExpressions, annotations);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(OWLClassExpression ... classExpressions) {
        this.checkNull(classExpressions, "classExpressions");
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLDisjointClassesAxiom(clses);
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(Set<? extends OWLDataPropertyExpression> properties, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(properties, "properties");
        this.checkNull(annotations, "annotations");
        return new OWLDisjointDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLDisjointDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(OWLDataPropertyExpression ... properties) {
        this.checkNull(properties, "properties");
        return this.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        this.checkNull(properties, "properties");
        return this.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLDisjointObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(Set<? extends OWLObjectPropertyExpression> properties, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(properties, "properties");
        this.checkNull(annotations, "annotations");
        return new OWLDisjointObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Set<? extends OWLClassExpression> classExpressions, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(classExpressions, "classExpressions");
        this.checkNull(annotations, "annotations");
        return new OWLEquivalentClassesAxiomImpl(classExpressions, annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB) {
        this.checkNull(clsA, "clsA");
        this.checkNull(clsB, "clsB");
        return this.getOWLEquivalentClassesAxiom(clsA, clsB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(clsA, "clsA");
        this.checkNull(clsB, "clsB");
        return this.getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{clsA, clsB}), annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression ... classExpressions) {
        this.checkNull(classExpressions, "classExpressions");
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLEquivalentClassesAxiom(clses);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLEquivalentClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(Set<? extends OWLDataPropertyExpression> properties, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(properties, "properties");
        this.checkNull(annotations, "annotations");
        return new OWLEquivalentDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLEquivalentDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB) {
        return this.getOWLEquivalentDataPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(propertyA, "propertyA");
        this.checkNull(propertyB, "propertyB");
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLDataPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression ... properties) {
        this.checkNull(properties, "properties");
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        this.checkNull(properties, "properties");
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLEquivalentObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB) {
        this.checkNull(propertyA, "propertyA");
        this.checkNull(propertyB, "propertyB");
        return this.getOWLEquivalentObjectPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(propertyA, "propertyA");
        this.checkNull(propertyB, "propertyB");
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLFunctionalDataPropertyAxiomImpl(property, annotations);
    }

    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property) {
        return this.getOWLFunctionalDataPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        this.checkNull(importedOntologyIRI, "importedOntologyIRI");
        return new OWLImportsDeclarationImpl(importedOntologyIRI);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(object, "object");
        this.checkNull(subject, "subject");
        this.checkNull(annotations, "annotations");
        return new OWLDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, int value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, double value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, float value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, boolean value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, String value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLNegativeDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(object, "object");
        this.checkNull(subject, "subject");
        this.checkNull(annotations, "annotations");
        return new OWLNegativeDataPropertyAssertionImplAxiom(subject, property, object, annotations);
    }

    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object) {
        return this.getOWLNegativeObjectPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(object, "object");
        this.checkNull(subject, "subject");
        this.checkNull(annotations, "annotations");
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object) {
        return this.getOWLObjectPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual) {
        return this.getOWLClassAssertionAxiom(classExpression, individual, EMPTY_ANNOTATIONS_SET);
    }

    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(classExpression, "classExpression");
        this.checkNull(individual, "individual");
        this.checkNull(annotations, "annotations");
        return new OWLClassAssertionImpl(individual, classExpression, annotations);
    }

    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLInverseFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLIrreflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLReflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLIrreflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(classExpression, "classExpression");
        this.checkNull(annotations, "annotations");
        return new OWLObjectPropertyDomainAxiomImpl(property, classExpression, annotations);
    }

    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        return this.getOWLObjectPropertyDomainAxiom(property, classExpression, EMPTY_ANNOTATIONS_SET);
    }

    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(range, "range");
        this.checkNull(annotations, "annotations");
        return new OWLObjectPropertyRangeAxiomImpl(property, range, annotations);
    }

    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range) {
        return this.getOWLObjectPropertyRangeAxiom(property, range, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(subProperty, "subProperty");
        this.checkNull(superProperty, "superProperty");
        this.checkNull(annotations, "annotations");
        return new OWLSubObjectPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLReflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(Set<? extends OWLIndividual> individuals, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(individuals, "individuals");
        this.checkNull(annotations, "annotations");
        return new OWLSameIndividualAxiomImpl(individuals, annotations);
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(OWLIndividual ... individuals) {
        this.checkNull(individuals, "individuals");
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        inds.addAll(Arrays.asList(individuals));
        return this.getOWLSameIndividualAxiom(inds);
    }

    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(Set<? extends OWLIndividual> individuals) {
        return this.getOWLSameIndividualAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(subClass, "subclass");
        this.checkNull(superClass, "superclass");
        this.checkNull(annotations, "annotations");
        return new OWLSubClassOfAxiomImpl(subClass, superClass, annotations);
    }

    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass) {
        return this.getOWLSubClassOfAxiom(subClass, superClass, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLSymmetricObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLSymmetricObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(annotations, "annotations");
        return new OWLTransitiveObjectPropertyAxiomImpl(property, annotations);
    }

    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLTransitiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectPropertyExpression property) {
        this.checkNull(property, "property");
        return new OWLObjectInverseOfImpl(property);
    }

    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(forwardProperty, "forwardProperty");
        this.checkNull(inverseProperty, "inverseProperty");
        this.checkNull(annotations, "annotations");
        return new OWLInverseObjectPropertiesAxiomImpl(forwardProperty, inverseProperty, annotations);
    }

    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty) {
        return this.getOWLInverseObjectPropertiesAxiom(forwardProperty, inverseProperty, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(superProperty, "superProperty");
        this.checkNull(chain, "chain");
        this.checkNull(annotations, "annotations");
        return new OWLSubPropertyChainAxiomImpl(chain, superProperty, annotations);
    }

    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubPropertyChainOfAxiom(chain, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, Set<? extends OWLPropertyExpression<?, ?>> properties, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(ce, "ce");
        this.checkNull(properties, "properties");
        this.checkNull(annotations, "annotations");
        return new OWLHasKeyAxiomImpl(ce, properties, annotations);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, Set<? extends OWLPropertyExpression<?, ?>> properties) {
        return this.getOWLHasKeyAxiom(ce, properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, OWLPropertyExpression<?, ?> ... properties) {
        this.checkNull(ce, "ce");
        this.checkNull(properties, "properties");
        return this.getOWLHasKeyAxiom(ce, CollectionFactory.createSet((Object[])properties));
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, Set<? extends OWLClassExpression> classExpressions, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(owlClass, "owlClass");
        this.checkNull(classExpressions, "classExpressions");
        this.checkNull(annotations, "annotations");
        return new OWLDisjointUnionAxiomImpl(owlClass, classExpressions, annotations);
    }

    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointUnionAxiom(owlClass, classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(Set<? extends OWLObjectPropertyExpression> properties, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(properties, "properties");
        this.checkNull(annotations, "annotations");
        return new OWLEquivalentObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(individual, "individual");
        this.checkNull(object, "object");
        this.checkNull(annotations, "annotations");
        return new OWLObjectPropertyAssertionAxiomImpl(individual, property, object, annotations);
    }

    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup) {
        return this.getOWLSubAnnotationPropertyOfAxiom(sub, sup, EMPTY_ANNOTATIONS_SET);
    }

    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(sub, "sub");
        this.checkNull(sup, "sup");
        this.checkNull(annotations, "annotations");
        return new OWLSubAnnotationPropertyOfAxiomImpl(sub, sup, annotations);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        this.checkNull(iri, IRI2);
        return this.data.getOWLAnnotationProperty(iri);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return this.getOWLAnnotation(property, value, EMPTY_ANNOTATIONS_SET);
    }

    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(property, "property");
        this.checkNull(value, VALUE2);
        this.checkNull(annotations, "annotations");
        return new OWLAnnotationImpl(property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation) {
        this.checkNull(annotation, "annotation");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotation.getAnnotations());
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, OWLAnnotation annotation, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(annotation, "annotation");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value) {
        return this.getOWLAnnotationAssertionAxiom(property, subject, value, EMPTY_ANNOTATIONS_SET);
    }

    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(subject, "subject");
        this.checkNull(property, "property");
        this.checkNull(value, VALUE2);
        this.checkNull(annotations, "annotations");
        return new OWLAnnotationAssertionAxiomImpl(subject, property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        this.checkNull(subject, "subject");
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), (OWLAnnotationSubject)subject, (OWLAnnotationValue)this.getOWLLiteral(true));
    }

    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(prop, "prop");
        this.checkNull(domain, "domain");
        this.checkNull(annotations, "annotations");
        return new OWLAnnotationPropertyDomainAxiomImpl(prop, domain, annotations);
    }

    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain) {
        return this.getOWLAnnotationPropertyDomainAxiom(prop, domain, EMPTY_ANNOTATIONS_SET);
    }

    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(prop, "prop");
        this.checkNull(range, "range");
        this.checkNull(annotations, "annotations");
        return new OWLAnnotationPropertyRangeAxiomImpl(prop, range, annotations);
    }

    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range) {
        return this.getOWLAnnotationPropertyRangeAxiom(prop, range, EMPTY_ANNOTATIONS_SET);
    }

    @Deprecated
    public SWRLRule getSWRLRule(IRI iri, Set<? extends SWRLAtom> body, Set<? extends SWRLAtom> head) {
        this.checkNull(iri, IRI2);
        this.checkNull(body, "body");
        this.checkNull(head, "head");
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>(2);
        annos.add(this.getOWLAnnotation(this.getOWLAnnotationProperty(IRI.create((String)"http://www.semanticweb.org/owlapi#iri")), (OWLAnnotationValue)this.getOWLLiteral(iri.toQuotedString())));
        return new SWRLRuleImpl(body, head, annos);
    }

    @Deprecated
    public SWRLRule getSWRLRule(NodeID nodeID, Set<? extends SWRLAtom> body, Set<? extends SWRLAtom> head) {
        this.checkNull(head, "head");
        this.checkNull(body, "body");
        this.checkNull(nodeID, "nodeID");
        HashSet<OWLAnnotation> annos = new HashSet<OWLAnnotation>(2);
        annos.add(this.getOWLAnnotation(this.getOWLAnnotationProperty(IRI.create((String)"http://www.semanticweb.org/owlapi#nodeID")), (OWLAnnotationValue)this.getOWLLiteral(nodeID.toString())));
        return new SWRLRuleImpl(body, head, annos);
    }

    public SWRLRule getSWRLRule(Set<? extends SWRLAtom> body, Set<? extends SWRLAtom> head, Set<OWLAnnotation> annotations) {
        this.checkNull(body, "body");
        this.checkNull(head, "head");
        this.checkNull(annotations, "annotations");
        return new SWRLRuleImpl(body, head, annotations);
    }

    public SWRLRule getSWRLRule(Set<? extends SWRLAtom> antecedent, Set<? extends SWRLAtom> consequent) {
        this.checkNull(antecedent, "antecedent");
        this.checkNull(consequent, "consequent");
        return new SWRLRuleImpl(antecedent, consequent);
    }

    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        this.checkNull(predicate, "predicate");
        this.checkNull(arg, "arg");
        return new SWRLClassAtomImpl(predicate, arg);
    }

    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        this.checkNull(predicate, "predicate");
        this.checkNull(arg, "arg");
        return new SWRLDataRangeAtomImpl(predicate, arg);
    }

    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        this.checkNull(property, "property");
        this.checkNull(arg0, "arg0");
        this.checkNull(arg1, "arg1");
        return new SWRLObjectPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        this.checkNull(property, "property");
        this.checkNull(arg0, "arg0");
        this.checkNull(arg1, "arg1");
        return new SWRLDataPropertyAtomImpl(property, arg0, arg1);
    }

    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        this.checkNull(builtInIRI, "builtInIRI");
        this.checkNull(args, "args");
        return new SWRLBuiltInAtomImpl(builtInIRI, args);
    }

    public SWRLVariable getSWRLVariable(IRI var) {
        this.checkNull(var, "var");
        return new SWRLVariableImpl(var);
    }

    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        this.checkNull(individual, "individual");
        return new SWRLIndividualArgumentImpl(individual);
    }

    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        this.checkNull(literal, LITERAL2);
        return new SWRLLiteralArgumentImpl(literal);
    }

    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        this.checkNull(arg0, "arg0");
        this.checkNull(arg1, "arg1");
        return new SWRLDifferentIndividualsAtomImpl(this, arg0, arg1);
    }

    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        this.checkNull(arg0, "arg0");
        this.checkNull(arg1, "arg1");
        return new SWRLSameIndividualAtomImpl(this, arg0, arg1);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange) {
        this.checkNull(datatype, DATATYPE2);
        this.checkNull(dataRange, DATA_RANGE);
        return this.getOWLDatatypeDefinitionAxiom(datatype, dataRange, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange, Set<? extends OWLAnnotation> annotations) {
        this.checkNull(datatype, DATATYPE2);
        this.checkNull(dataRange, DATA_RANGE);
        this.checkNull(annotations, "annotations");
        return new OWLDatatypeDefinitionAxiomImpl(datatype, dataRange, annotations);
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        this.checkNull(lexicalValue, "lexicalValue");
        this.checkNull(datatype, DATATYPE2);
        return this.data.getOWLLiteral(lexicalValue, datatype);
    }

    public OWLLiteral getOWLLiteral(int value) {
        return this.data.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(double value) {
        return this.data.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(float value) {
        return this.data.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String value) {
        this.checkNull(value, VALUE2);
        return this.data.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String literal, String lang) {
        this.checkNull(literal, LITERAL2);
        return this.data.getOWLLiteral(literal, lang);
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return this.data.getBooleanOWLDatatype();
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return this.data.getDoubleOWLDatatype();
    }

    public OWLDatatype getFloatOWLDatatype() {
        return this.data.getFloatOWLDatatype();
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return this.data.getIntegerOWLDatatype();
    }

    public OWLDatatype getTopDatatype() {
        return this.data.getTopDatatype();
    }

    public OWLDatatype getRDFPlainLiteral() {
        return this.data.getRDFPlainLiteral();
    }
}

