/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.Comparator;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class OWLEntityComparator
implements Comparator<OWLEntity>,
OWLEntityVisitor,
Serializable {
    private static final long serialVersionUID = 30406L;
    int lastValue;
    private static final int OWL_CLASS_INDEX = 0;
    private static final int OWL_OBJECT_PROPERTY_INDEX = 1;
    private static final int OWL_DATA_PROPERTY_INDEX = 2;
    private static final int OWL_INDIVIDUAL_INDEX = 3;
    private static final int OWL_DATATYPE_INDEX = 4;
    private final ShortFormProvider shortFormProvider;

    public OWLEntityComparator(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    @Override
    public int compare(OWLEntity o1, OWLEntity o2) {
        o1.accept(this);
        int i1 = this.lastValue;
        o2.accept(this);
        int i2 = this.lastValue;
        int delta = i1 - i2;
        if (delta != 0) {
            return delta;
        }
        String s1 = this.getShortForm(o1);
        String s2 = this.getShortForm(o2);
        return s1.compareTo(s2);
    }

    private String getShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void visit(OWLClass cls) {
        this.lastValue = 0;
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.lastValue = 1;
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.lastValue = 2;
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.lastValue = 3;
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.lastValue = 4;
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.lastValue = 5;
    }
}

