/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.Namespaces;

public class DefaultPrefixManager
implements PrefixManager,
ShortFormProvider,
IRIShortFormProvider {
    private static final long serialVersionUID = 30406L;
    private static final StringLengthComparator STRING_LENGTH_COMPARATOR = new StringLengthComparator();
    private final Map<String, String> prefix2NamespaceMap;

    public DefaultPrefixManager() {
        this(STRING_LENGTH_COMPARATOR);
    }

    public DefaultPrefixManager(Comparator<String> c) {
        this.prefix2NamespaceMap = new TreeMap<String, String>(c);
        this.setupDefaultPrefixes();
    }

    public DefaultPrefixManager(PrefixManager pm) {
        this();
        this.addPrefixes(pm);
    }

    public void addPrefixes(PrefixManager pm) {
        for (String prefixName : pm.getPrefixNames()) {
            String prefix = pm.getPrefix(prefixName);
            if (prefix == null) continue;
            this.prefix2NamespaceMap.put(prefixName, prefix);
        }
    }

    public DefaultPrefixManager(PrefixManager pm, Comparator<String> c) {
        this(c);
        this.addPrefixes(pm);
    }

    public void clear() {
        this.prefix2NamespaceMap.clear();
    }

    @Override
    public Set<String> getPrefixNames() {
        return new HashSet<String>(this.prefix2NamespaceMap.keySet());
    }

    public DefaultPrefixManager(String defaultPrefix) {
        this();
        if (defaultPrefix != null) {
            this.setDefaultPrefix(defaultPrefix);
        }
    }

    public DefaultPrefixManager(String defaultPrefix, Comparator<String> c) {
        this(c);
        if (defaultPrefix != null) {
            this.setDefaultPrefix(defaultPrefix);
        }
    }

    private void setupDefaultPrefixes() {
        this.setPrefix("owl:", Namespaces.OWL.toString());
        this.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.setPrefix("rdf:", Namespaces.RDF.toString());
        this.setPrefix("xsd:", Namespaces.XSD.toString());
        this.setPrefix("xml:", Namespaces.XML.toString());
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.setPrefix(":", defaultPrefix);
    }

    @Override
    public String getPrefixIRI(IRI iri) {
        String ns = iri.getNamespace();
        for (String prefixName : this.prefix2NamespaceMap.keySet()) {
            String prefix = this.prefix2NamespaceMap.get(prefixName);
            if (!ns.equals(prefix)) continue;
            String ncNameSuffix = iri.getFragment();
            if (ncNameSuffix == null) {
                ncNameSuffix = "";
            }
            return prefixName + ncNameSuffix;
        }
        return null;
    }

    @Override
    public String getDefaultPrefix() {
        return this.prefix2NamespaceMap.get(":");
    }

    @Override
    public boolean containsPrefixMapping(String prefix) {
        return this.prefix2NamespaceMap.containsKey(prefix) && this.prefix2NamespaceMap.get(prefix) != null;
    }

    @Override
    public IRI getIRI(String curie) {
        if (curie.startsWith("<")) {
            return IRI.create(curie.substring(1, curie.length() - 1));
        }
        int sep = curie.indexOf(58);
        if (sep == -1) {
            if (this.getDefaultPrefix() != null) {
                return IRI.create(this.getDefaultPrefix() + curie);
            }
            return IRI.create(curie);
        }
        String prefixName = curie.substring(0, sep + 1);
        if (!this.containsPrefixMapping(prefixName)) {
            throw new RuntimeException("Prefix not registered for prefix name: " + prefixName);
        }
        String prefix = this.getPrefix(prefixName);
        String localName = curie.substring(sep + 1);
        return IRI.create(prefix, localName);
    }

    @Override
    public Map<String, String> getPrefixName2PrefixMap() {
        return Collections.unmodifiableMap(this.prefix2NamespaceMap);
    }

    @Override
    public String getPrefix(String prefixName) {
        return this.prefix2NamespaceMap.get(prefixName);
    }

    public void setPrefix(String prefixName, String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        if (prefixName == null) {
            throw new IllegalArgumentException("prefixName cannot be null");
        }
        if (!prefixName.endsWith(":")) {
            throw new IllegalArgumentException("Prefix names must end with a colon (:)");
        }
        this.prefix2NamespaceMap.put(prefixName, prefix);
    }

    public void unregisterNamespace(String namespace) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.prefix2NamespaceMap.entrySet()) {
            if (!e.getValue().equals(namespace)) continue;
            toRemove.add(e.getKey());
        }
        for (String s : toRemove) {
            this.prefix2NamespaceMap.remove(s);
        }
    }

    @Override
    public String getShortForm(IRI iri) {
        String sf = this.getPrefixIRI(iri);
        if (sf == null) {
            return iri.toQuotedString();
        }
        return sf;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        return this.getShortForm(entity.getIRI());
    }

    @Override
    public void dispose() {
    }

    private static final class StringLengthComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public int compare(String o1, String o2) {
            int diff = o1.length() - o2.length();
            if (diff != 0) {
                return diff;
            }
            return o1.compareTo(o2);
        }
    }
}

