/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLOntologyStorer
implements OWLOntologyStorer {
    private static final long serialVersionUID = 30406L;
    private static final String UTF_8 = "UTF-8";
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @Override
    public final void storeOntology(OWLOntologyManager manager, OWLOntology ontology, IRI documentIRI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        this.storeOntology(ontology, documentIRI, ontologyFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void storeOntology(OWLOntology ontology, IRI documentIRI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        try {
            if (!documentIRI.isAbsolute()) {
                throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
            }
            File tempFile = null;
            FileOutputStream tempOutputStream = null;
            FileInputStream tempInputStream = null;
            InputStreamReader inputStreamReader = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedReader br = null;
            BufferedWriter w = null;
            OutputStream os = null;
            try {
                os = this.prepareActualOutput(documentIRI);
                boolean useTemp = Boolean.parseBoolean(ontologyFormat.getParameter(OWLOntologyFormat.USE_INTERMEDIATE_OUTPUT_FILE, Boolean.FALSE).toString());
                if (useTemp) {
                    tempFile = File.createTempFile("owlapi", ".owl");
                    tempOutputStream = new FileOutputStream(tempFile);
                    this.store(ontology, ontologyFormat, tempOutputStream);
                    tempInputStream = new FileInputStream(tempFile);
                    inputStreamReader = new InputStreamReader((InputStream)tempInputStream, UTF_8);
                    br = new BufferedReader(inputStreamReader);
                    outputStreamWriter = new OutputStreamWriter(os, UTF_8);
                    w = new BufferedWriter(outputStreamWriter);
                    String line = br.readLine();
                    while (line != null) {
                        w.write(line);
                        w.write("\n");
                        line = br.readLine();
                    }
                } else {
                    this.store(ontology, ontologyFormat, os);
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (w != null) {
                    w.close();
                }
                if (os != null) {
                    os.close();
                }
                if (tempOutputStream != null) {
                    tempOutputStream.close();
                }
                if (tempInputStream != null) {
                    tempInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (tempFile != null && !tempFile.delete()) {
                    this.LOGGER.warn("Temporary file " + tempFile.getAbsolutePath() + " cannot be deleted.");
                }
            }
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    private OutputStream prepareActualOutput(IRI documentIRI) throws FileNotFoundException, MalformedURLException, IOException {
        OutputStream os;
        if (documentIRI.getScheme().equals("file")) {
            File file = new File(documentIRI.toURI());
            file.getParentFile().mkdirs();
            os = new FileOutputStream(file);
        } else {
            URL url = documentIRI.toURI().toURL();
            URLConnection conn = url.openConnection();
            os = conn.getOutputStream();
        }
        return os;
    }

    private void store(OWLOntology ontology, OWLOntologyFormat ontologyFormat, OutputStream tempOutputStream) throws OWLOntologyStorageException, IOException {
        BufferedWriter tempWriter = new BufferedWriter(new OutputStreamWriter(tempOutputStream, UTF_8));
        this.storeOntology(ontology, tempWriter, ontologyFormat);
        ((Writer)tempWriter).flush();
        ((Writer)tempWriter).close();
    }

    @Override
    public final void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OWLOntologyDocumentTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, target, format);
    }

    @Override
    public final void storeOntology(OWLOntology ontology, OWLOntologyDocumentTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (target.isWriterAvailable()) {
            try {
                Writer writer = target.getWriter();
                this.storeOntology(ontology, writer, format);
                writer.flush();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isOutputStreamAvailable()) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8));
                this.storeOntology(ontology, writer, format);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isDocumentIRIAvailable()) {
            this.storeOntology(ontology, target.getDocumentIRI(), format);
        } else {
            throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Document IRI could be obtained to store the ontology");
        }
    }

    @Deprecated
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OutputStream outputStream, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, outputStream, format);
    }

    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (!format.isTextual()) {
            throw new OWLOntologyStorageException("Could not store this non-textual format to the given OutputStream as support has not yet been implemented by this OWLOntologyStorer. format=" + format.toString());
        }
        this.storeOntology(ontology, new OutputStreamWriter(outputStream, Charset.forName(UTF_8)), format);
    }

    @Deprecated
    protected abstract void storeOntology(OWLOntologyManager var1, OWLOntology var2, Writer var3, OWLOntologyFormat var4) throws OWLOntologyStorageException;

    protected abstract void storeOntology(OWLOntology var1, Writer var2, OWLOntologyFormat var3) throws OWLOntologyStorageException;
}

