/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import com.github.ansell.abstractserviceloader.AbstractServiceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class OWLReasonerFactoryRegistry
extends AbstractServiceLoader<String, OWLReasonerFactory> {
    private static final OWLReasonerFactoryRegistry instance = new OWLReasonerFactoryRegistry();

    public OWLReasonerFactoryRegistry() {
        super(OWLReasonerFactory.class);
    }

    public static OWLReasonerFactoryRegistry getInstance() {
        return instance;
    }

    public void clearReasonerFactories() {
        this.clear();
    }

    public List<OWLReasonerFactory> getReasonerFactories() {
        return new ArrayList<OWLReasonerFactory>(this.getAll());
    }

    public OWLReasonerFactory getReasonerFactory(String key) {
        Collection collection = this.get(key);
        if (collection.isEmpty()) {
            return null;
        }
        return (OWLReasonerFactory)collection.iterator().next();
    }

    public Collection<OWLReasonerFactory> getReasonerFactoriesByProfile(OWLProfile profile) {
        HashSet<OWLReasonerFactory> results = new HashSet<OWLReasonerFactory>();
        for (OWLReasonerFactory nextFactory : this.getAll()) {
            if (!nextFactory.getSupportedProfiles().contains(profile)) continue;
            results.add(nextFactory);
        }
        return results;
    }

    public void registerReasonerFactory(OWLReasonerFactory reasonerFactory) {
        this.add(reasonerFactory);
    }

    public void unregisterReasonerFactory(OWLReasonerFactory reasonerFactory) {
        this.remove(reasonerFactory);
    }

    public String getKey(OWLReasonerFactory service) {
        return service.getReasonerName();
    }
}

