/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import com.github.ansell.abstractserviceloader.AbstractServiceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.profiles.OWLProfile;

public class OWLProfileRegistry
extends AbstractServiceLoader<IRI, OWLProfile> {
    private static final OWLProfileRegistry instance = new OWLProfileRegistry();

    public static OWLProfileRegistry getInstance() {
        return instance;
    }

    public OWLProfileRegistry() {
        super(OWLProfile.class);
    }

    public void clearProfileFactories() {
        this.clear();
    }

    public IRI getKey(OWLProfile service) {
        return service.getIRI();
    }

    public OWLProfile getProfile(IRI key) {
        Collection collection = this.get(key);
        if (collection.isEmpty()) {
            return null;
        }
        return (OWLProfile)collection.iterator().next();
    }

    public List<OWLProfile> getProfiles() {
        return new ArrayList<OWLProfile>(this.getAll());
    }

    public void registerProfileFactory(OWLProfile profile) {
        this.add(profile);
    }

    public void unregisterProfileFactory(OWLProfile profile) {
        this.remove(profile);
    }
}

