/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.github.ansell.abstractserviceloader.AbstractServiceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.model.OWLOntologyStorerFactory;

public class OWLOntologyStorerFactoryRegistry
extends AbstractServiceLoader<OWLOntologyFormatFactory, OWLOntologyStorerFactory> {
    private static final OWLOntologyStorerFactoryRegistry instance = new OWLOntologyStorerFactoryRegistry();

    public OWLOntologyStorerFactoryRegistry() {
        super(OWLOntologyStorerFactory.class);
    }

    public static OWLOntologyStorerFactoryRegistry getInstance() {
        return instance;
    }

    public void clearStorerFactories() {
        this.clear();
    }

    public List<OWLOntologyStorerFactory> getStorerFactories() {
        return new ArrayList<OWLOntologyStorerFactory>(this.getAll());
    }

    public OWLOntologyStorerFactory getStorerFactory(OWLOntologyFormatFactory key) {
        Collection collection = this.get(key);
        if (collection.isEmpty()) {
            return null;
        }
        return (OWLOntologyStorerFactory)collection.iterator().next();
    }

    public void registerStorerFactory(OWLOntologyStorerFactory storerFactory) {
        this.add(storerFactory);
    }

    public void unregisterStorerFactory(OWLOntologyStorerFactory storerFactory) {
        this.remove(storerFactory);
    }

    public OWLOntologyFormatFactory getKey(OWLOntologyStorerFactory service) {
        return service.getFormatFactory();
    }
}

