/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.github.ansell.abstractserviceloader.AbstractServiceLoader;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.io.OWLParserFactoryRegistry;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLOntologyStorerFactoryRegistry;

public class OWLOntologyManagerFactoryRegistry
extends AbstractServiceLoader<String, OWLOntologyManagerFactory> {
    private static final OWLOntologyManagerFactoryRegistry instance = new OWLOntologyManagerFactoryRegistry();

    public OWLOntologyManagerFactoryRegistry() {
        super(OWLOntologyManagerFactory.class);
    }

    public static OWLOntologyManagerFactoryRegistry getInstance() {
        return instance;
    }

    public void clearManagerFactories() {
        this.clear();
    }

    public List<OWLOntologyManagerFactory> getOntologyManagerFactories() {
        return new ArrayList<OWLOntologyManagerFactory>(this.getAll());
    }

    public void registerOntologyManagerFactory(OWLOntologyManagerFactory managerFactory) {
        this.add(managerFactory);
    }

    public void unregisterOntologyManagerFactory(OWLOntologyManagerFactory managerFactory) {
        this.remove(managerFactory);
    }

    public String getKey(OWLOntologyManagerFactory service) {
        return service.getClass().getName();
    }

    public static OWLOntologyManager createOWLOntologyManager() {
        return OWLOntologyManagerFactoryRegistry.createOWLOntologyManager(OWLOntologyManagerFactoryRegistry.getOWLDataFactory());
    }

    public static OWLOntologyManager createOWLOntologyManager(OWLDataFactory dataFactory) {
        return OWLOntologyManagerFactoryRegistry.createOWLOntologyManager(dataFactory, OWLOntologyStorerFactoryRegistry.getInstance(), OWLParserFactoryRegistry.getInstance());
    }

    public static OWLOntologyManager createOWLOntologyManager(OWLDataFactory dataFactory, OWLOntologyStorerFactoryRegistry storerRegistry, OWLParserFactoryRegistry parserRegistry) {
        if (instance.getOntologyManagerFactories().isEmpty()) {
            throw new IllegalStateException("Could not find an OWLOntologyManagerFactory implementations");
        }
        return instance.getOntologyManagerFactories().iterator().next().buildOWLOntologyManager(dataFactory, storerRegistry, parserRegistry);
    }

    public static OWLDataFactory getOWLDataFactory() {
        if (instance.getOntologyManagerFactories().isEmpty()) {
            throw new IllegalStateException("Could not find any OWLOntologyManagerFactory implementations");
        }
        return instance.getOntologyManagerFactories().iterator().next().getFactory();
    }
}

