/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Serializable;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;

public class RDFTriple
implements Comparable<RDFTriple>,
Serializable {
    private static final long serialVersionUID = 30406L;
    private final RDFResource subject;
    private final RDFResourceIRI predicate;
    private final RDFNode object;

    public RDFTriple(RDFResource subject, RDFResourceIRI predicate, RDFNode object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, IRI object, boolean objectAnon) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subjectAnon ? new RDFResourceBlankNode(subject) : new RDFResourceIRI(subject);
        this.predicate = new RDFResourceIRI(predicate);
        this.object = objectAnon ? new RDFResourceBlankNode(object) : new RDFResourceIRI(object);
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, OWLLiteral object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subjectAnon ? new RDFResourceBlankNode(subject) : new RDFResourceIRI(subject);
        this.predicate = new RDFResourceIRI(predicate);
        this.object = new RDFLiteral(object);
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Deprecated
    public RDFResourceIRI getProperty() {
        return this.getPredicate();
    }

    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)o;
        return this.subject.equals(other.getSubject()) && this.predicate.equals(other.getPredicate()) && this.object.equals(other.getObject());
    }

    @Override
    public int compareTo(RDFTriple o) {
        if (this == o) {
            return 0;
        }
        if (this.getSubject().equals(o.getSubject())) {
            if (this.getPredicate().equals(o.getPredicate())) {
                if (this.getObject().equals(o.getObject())) {
                    return 0;
                }
                return this.getObject().compareTo(o.getObject());
            }
            return this.getPredicate().compareTo(o.getPredicate());
        }
        return this.getSubject().compareTo(o.getSubject());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subject.toString());
        sb.append(" ");
        sb.append(this.predicate.toString());
        sb.append(" ");
        sb.append(this.object.toString());
        sb.append(".");
        return sb.toString();
    }
}

