/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Serializable;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;

public class RDFLiteral
extends RDFNode
implements Serializable {
    private static final long serialVersionUID = 30406L;
    private String literalString;
    private String lang;
    private IRI datatype;
    private int hashCode;

    public RDFLiteral(String literal, IRI datatype) {
        this.literalString = literal;
        this.datatype = datatype;
    }

    public RDFLiteral(String literal, String lang) {
        this.literalString = literal;
        this.lang = lang;
    }

    public RDFLiteral(OWLLiteral literal) {
        if (literal.getLiteral() == null) {
            throw new IllegalArgumentException("A literal must always have a non-null value");
        }
        this.literalString = literal.getLiteral();
        this.lang = literal.getLang();
        if (literal.getDatatype() != null) {
            this.datatype = literal.getDatatype().getIRI();
        }
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37;
            this.hashCode = this.hashCode * 37 + this.literalString.hashCode();
            if (this.lang != null) {
                this.hashCode = this.hashCode * 37 + this.lang.hashCode();
            }
            if (this.datatype != null) {
                this.hashCode = this.hashCode * 37 + this.datatype.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RDFLiteral)) {
            return false;
        }
        RDFLiteral other = (RDFLiteral)o;
        if (!this.literalString.equals(other.stringValue())) {
            return false;
        }
        if (this.getLang() != null) {
            if (other.getLang() == null) {
                return false;
            }
            return this.getLang().equals(other.getLang());
        }
        if (other.getLang() != null) {
            return false;
        }
        if (this.getDatatype() != null) {
            if (other.getDatatype() == null) {
                return false;
            }
            return this.getDatatype().equals(other.getDatatype());
        }
        return other.getDatatype() == null;
    }

    @Override
    public int compareTo(RDFNode b) {
        if (this == b) {
            return 0;
        }
        if (!(b instanceof RDFLiteral)) {
            return -1;
        }
        RDFLiteral lit2 = (RDFLiteral)b;
        int compareTo = this.stringValue().compareTo(lit2.stringValue());
        if (compareTo != 0) {
            return compareTo;
        }
        if (this.getLang() != null) {
            if (lit2.getLang() != null) {
                return this.getLang().compareTo(lit2.getLang());
            }
            return 1;
        }
        if (lit2.getLang() != null) {
            return -1;
        }
        if (this.hasDatatype()) {
            if (lit2.hasDatatype()) {
                return this.getDatatype().compareTo(lit2.getDatatype());
            }
            return 1;
        }
        if (lit2.hasDatatype()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.literalString;
    }

    @Deprecated
    public String getLiteral() {
        return this.stringValue();
    }

    @Override
    public IRI getIRI() {
        return null;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public String stringValue() {
        return this.literalString;
    }

    public String getLang() {
        return this.lang;
    }

    public IRI getDatatype() {
        return this.datatype;
    }

    public boolean hasLang() {
        return this.lang != null && !this.lang.trim().isEmpty();
    }

    public boolean hasDatatype() {
        return this.datatype != null;
    }

    @Deprecated
    public boolean isTyped() {
        return this.hasDatatype();
    }
}

