/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class GZipStreamDocumentTarget
implements OWLOntologyDocumentTarget {
    private final File out;
    private OutputStream outputStream;

    public GZipStreamDocumentTarget(File os) {
        this.out = os;
    }

    @Override
    public boolean isWriterAvailable() {
        return false;
    }

    @Override
    public Writer getWriter() {
        throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                this.outputStream = new GZIPOutputStream(new FileOutputStream(this.out));
            }
            catch (FileNotFoundException e) {
                throw new OWLRuntimeException(e);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
        return this.outputStream;
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return true;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.out);
    }
}

