/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class GZipStreamDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private final File file;
    private final OWLOntologyFormatFactory format;

    public GZipStreamDocumentSource(File is) {
        this(is, GZipStreamDocumentSource.getNextDocumentIRI(), null);
    }

    public GZipStreamDocumentSource(File is, OWLOntologyFormatFactory format) {
        this(is, GZipStreamDocumentSource.getNextDocumentIRI(), format);
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("gzipinputstream:ontology" + ++counter);
    }

    public GZipStreamDocumentSource(File stream, IRI documentIRI) {
        this(stream, documentIRI, null);
    }

    public GZipStreamDocumentSource(File stream, IRI documentIRI, OWLOntologyFormatFactory format) {
        this.documentIRI = documentIRI;
        this.file = stream;
        this.format = format;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new GZIPInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLRuntimeException("File not found - check that the input stream is available before calling this method.");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return this.isInputStreamAvailable();
    }

    @Override
    public OWLOntologyFormatFactory getFormatFactory() {
        return this.format;
    }

    @Override
    public boolean isFormatKnown() {
        return this.format != null;
    }
}

