/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactoryRegistry;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;

public class FileDocumentSource
implements OWLOntologyDocumentSource {
    private final File file;
    private final OWLOntologyFormatFactory format;

    public FileDocumentSource(File file) {
        this.file = file;
        this.format = null;
    }

    public FileDocumentSource(File file, OWLOntologyFormatFactory format) {
        this.file = file;
        this.format = format;
    }

    public FileDocumentSource(File file, String mimeType) {
        this.file = file;
        this.format = OWLOntologyFormatFactoryRegistry.getInstance().getByMIMEType(mimeType);
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.file);
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public OWLOntologyFormatFactory getFormatFactory() {
        return this.format;
    }

    @Override
    public boolean isFormatKnown() {
        return this.format != null;
    }
}

