/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OWLEntityRemover
implements OWLEntityVisitor {
    private final List<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
    private final Collection<OWLOntology> ontologies;

    public OWLEntityRemover(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies) {
        this.ontologies = new ArrayList<OWLOntology>(ontologies);
    }

    public List<OWLOntologyChange> getChanges() {
        return new ArrayList<OWLOntologyChange>(this.changes);
    }

    public void reset() {
        this.changes.clear();
    }

    private void generateChanges(OWLEntity entity) {
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom oWLAxiom : ont.getReferencingAxioms(entity)) {
                this.changes.add(new RemoveAxiom(ont, oWLAxiom));
            }
            for (OWLAnnotationAssertionAxiom oWLAnnotationAssertionAxiom : ont.getAnnotationAssertionAxioms(entity.getIRI())) {
                this.changes.add(new RemoveAxiom(ont, oWLAnnotationAssertionAxiom));
            }
        }
    }

    @Override
    public void visit(OWLClass cls) {
        this.generateChanges(cls);
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.generateChanges(datatype);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.generateChanges(individual);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.generateChanges(property);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.generateChanges(property);
    }
}

