/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;

public abstract class AbstractOWLOntologyStorer
implements OWLOntologyStorer {
    private static final long serialVersionUID = 30402L;
    private static final String UTF_8 = "UTF-8";

    @Override
    public final void storeOntology(OWLOntologyManager manager, OWLOntology ontology, IRI documentIRI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        this.storeOntology(ontology, documentIRI, ontologyFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void storeOntology(OWLOntology ontology, IRI documentIRI, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException {
        try {
            if (!documentIRI.isAbsolute()) {
                throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
            }
            File tempFile = File.createTempFile("owlapi", ".owl");
            FileOutputStream tempOutputStream = null;
            FileInputStream tempInputStream = null;
            InputStreamReader inputStreamReader = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedReader br = null;
            BufferedWriter w = null;
            OutputStream os = null;
            try {
                tempOutputStream = new FileOutputStream(tempFile);
                BufferedWriter tempWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)tempOutputStream, UTF_8));
                this.storeOntology(ontology, tempWriter, ontologyFormat);
                ((Writer)tempWriter).flush();
                ((Writer)tempWriter).close();
                if (documentIRI.getScheme().equals("file")) {
                    File file = new File(documentIRI.toURI());
                    file.getParentFile().mkdirs();
                    os = new FileOutputStream(file);
                } else {
                    URL url = documentIRI.toURI().toURL();
                    URLConnection conn = url.openConnection();
                    os = conn.getOutputStream();
                }
                tempInputStream = new FileInputStream(tempFile);
                inputStreamReader = new InputStreamReader((InputStream)tempInputStream, UTF_8);
                br = new BufferedReader(inputStreamReader);
                outputStreamWriter = new OutputStreamWriter(os, UTF_8);
                w = new BufferedWriter(outputStreamWriter);
                String line = br.readLine();
                while (line != null) {
                    w.write(line);
                    w.write("\n");
                    line = br.readLine();
                }
            }
            finally {
                tempFile.delete();
                if (br != null) {
                    br.close();
                }
                if (w != null) {
                    w.close();
                }
                if (os != null) {
                    os.close();
                }
                if (tempOutputStream != null) {
                    tempOutputStream.close();
                }
                if (tempInputStream != null) {
                    tempInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    public final void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OWLOntologyDocumentTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, target, format);
    }

    @Override
    public final void storeOntology(OWLOntology ontology, OWLOntologyDocumentTarget target, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (target.isWriterAvailable()) {
            try {
                Writer writer = target.getWriter();
                this.storeOntology(ontology, writer, format);
                writer.flush();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isOutputStreamAvailable()) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter(target.getOutputStream(), UTF_8));
                this.storeOntology(ontology, writer, format);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException(e);
            }
        } else if (target.isDocumentIRIAvailable()) {
            this.storeOntology(ontology, target.getDocumentIRI(), format);
        } else {
            throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Document IRI could be obtained to store the ontology");
        }
    }

    @Deprecated
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, OutputStream outputStream, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, outputStream, format);
    }

    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLOntologyFormat format) throws OWLOntologyStorageException {
        if (!format.isTextual()) {
            throw new OWLOntologyStorageException("Could not store this non-textual format to the given OutputStream as support has not yet been implemented by this OWLOntologyStorer. format=" + format.toString());
        }
        this.storeOntology(ontology, new OutputStreamWriter(outputStream, Charset.forName(UTF_8)), format);
    }

    @Deprecated
    protected abstract void storeOntology(OWLOntologyManager var1, OWLOntology var2, Writer var3, OWLOntologyFormat var4) throws OWLOntologyStorageException;

    protected abstract void storeOntology(OWLOntology var1, Writer var2, OWLOntologyFormat var3) throws OWLOntologyStorageException;
}

