/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.rio.RioParser;

public class UnparsableOntologyException
extends OWLOntologyCreationException {
    private static final long serialVersionUID = 30402L;
    private static boolean includeStackTraceInMessage = false;
    private final IRI documentIRI;
    private final Map<OWLParser, OWLParserException> exceptions;

    public UnparsableOntologyException(IRI documentIRI, Map<OWLParser, OWLParserException> exceptions) {
        super("Could not parse ontology from document IRI: " + documentIRI.toQuotedString());
        this.documentIRI = documentIRI;
        this.exceptions = new LinkedHashMap<OWLParser, OWLParserException>(exceptions);
    }

    @Override
    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Problem parsing ");
        msg.append(this.documentIRI);
        msg.append("\n");
        msg.append("Could not parse ontology.  Either a suitable parser could not be found, or parsing failed.  See parser logs below for explanation.\n");
        msg.append("The following parsers were tried:\n");
        int counter = 1;
        for (OWLParser parser : this.exceptions.keySet()) {
            msg.append(counter);
            msg.append(") ");
            msg.append(parser.getClass().getSimpleName());
            if (parser instanceof RioParser) {
                msg.append(" ");
                msg.append(((RioParser)parser).getParserFormat());
            }
            msg.append("\n");
            ++counter;
        }
        msg.append("\n\nDetailed logs:\n");
        for (OWLParser parser : this.exceptions.keySet()) {
            Throwable exception = this.exceptions.get(parser);
            msg.append("--------------------------------------------------------------------------------\n");
            msg.append("Parser: ");
            msg.append(parser.getClass().getSimpleName());
            if (parser instanceof RioParser) {
                msg.append(" ");
                msg.append(((RioParser)parser).getParserFormat());
            }
            msg.append("\n");
            msg.append(exception.getMessage());
            msg.append("\n\n");
            if (!includeStackTraceInMessage) continue;
            msg.append("    Stack trace:\n");
            for (StackTraceElement element : exception.getStackTrace()) {
                msg.append("        ");
                msg.append(element.toString());
                msg.append("\n");
            }
            msg.append("\n\n");
        }
        return msg.toString();
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    public static boolean isIncludeStackTraceInMessage() {
        return includeStackTraceInMessage;
    }

    public static void setIncludeStackTraceInMessage(boolean includeStackTraceInMessage) {
        UnparsableOntologyException.includeStackTraceInMessage = includeStackTraceInMessage;
    }

    public Map<OWLParser, OWLParserException> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }
}

