/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactoryRegistry;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class StringDocumentSource
implements OWLOntologyDocumentSource {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final IRI documentIRI;
    private final String string;
    private OWLOntologyFormatFactory format;

    public StringDocumentSource(String string) {
        this(string, StringDocumentSource.getNextDocumentIRI());
    }

    public StringDocumentSource(String string, OWLOntologyFormatFactory format) {
        this(string, StringDocumentSource.getNextDocumentIRI(), format);
    }

    public StringDocumentSource(String string, String mimeType) {
        this(string, StringDocumentSource.getNextDocumentIRI(), mimeType);
    }

    public static IRI getNextDocumentIRI() {
        return IRI.create("string:ontology" + counter.incrementAndGet());
    }

    public StringDocumentSource(String string, IRI documentIRI) {
        this.string = string;
        this.documentIRI = documentIRI;
    }

    public StringDocumentSource(String string, IRI documentIRI, OWLOntologyFormatFactory format) {
        this(string, documentIRI);
        this.format = format;
    }

    public StringDocumentSource(String string, IRI documentIRI, String mimeType) {
        this(string, documentIRI);
        OWLOntologyFormatFactory formatFactory = OWLOntologyFormatFactoryRegistry.getInstance().getByMIMEType(mimeType);
        if (formatFactory != null) {
            this.format = formatFactory;
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.string);
    }

    @Override
    public boolean isInputStreamAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        throw new OWLRuntimeException("InputStream not available.  Check with StringDocumentSource.isInputStreamAvailable() first!");
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public OWLOntologyFormatFactory getFormatFactory() {
        return this.format;
    }

    @Override
    public boolean isFormatKnown() {
        return this.format != null;
    }
}

