/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactoryRegistry;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDocumentSource
implements OWLOntologyDocumentSource {
    private static final Logger log = LoggerFactory.getLogger(StreamDocumentSource.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final IRI documentIRI;
    private byte[] buffer;
    private OWLOntologyFormatFactory format;

    public StreamDocumentSource(InputStream is) {
        this(is, StreamDocumentSource.getNextDocumentIRI());
    }

    public StreamDocumentSource(InputStream is, OWLOntologyFormatFactory format) {
        this(is, StreamDocumentSource.getNextDocumentIRI(), format);
    }

    public StreamDocumentSource(InputStream is, String mimeType) {
        this(is, StreamDocumentSource.getNextDocumentIRI(), mimeType);
    }

    public static IRI getNextDocumentIRI() {
        return IRI.create("inputstream:ontology" + counter.incrementAndGet());
    }

    public StreamDocumentSource(InputStream stream, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.readIntoBuffer(stream);
    }

    public StreamDocumentSource(InputStream stream, IRI documentIRI, String mimeType) {
        this(stream, documentIRI);
        OWLOntologyFormatFactory formatFactory = OWLOntologyFormatFactoryRegistry.getInstance().getByMIMEType(mimeType);
        if (formatFactory != null) {
            this.format = formatFactory;
        }
    }

    public StreamDocumentSource(InputStream stream, IRI documentIRI, OWLOntologyFormatFactory format) {
        this(stream, documentIRI);
        this.format = format;
    }

    private void readIntoBuffer(InputStream reader) {
        long start = System.currentTimeMillis();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            int length = 100000;
            byte[] tempBuffer = new byte[100000];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, 100000)) <= 0) continue;
                bos.write(tempBuffer, 0, read);
            } while (read > 0);
            this.buffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("readIntoBuffer: timing={}", (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buffer);
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        throw new OWLRuntimeException("Reader not available.  Check with StreamDocumentSource.isReaderAvailable() first!");
    }

    @Override
    public boolean isReaderAvailable() {
        return false;
    }

    @Override
    public OWLOntologyFormatFactory getFormatFactory() {
        return this.format;
    }

    @Override
    public boolean isFormatKnown() {
        return this.format != null;
    }
}

