/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;

public class RDFTriple {
    private final RDFResource subject;
    private final RDFResourceIRI predicate;
    private final RDFNode object;

    public RDFTriple(RDFResource subject, RDFResourceIRI predicate, RDFNode object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, IRI object, boolean objectAnon) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subjectAnon ? new RDFResourceBlankNode(subject) : new RDFResourceIRI(subject);
        this.predicate = new RDFResourceIRI(predicate);
        this.object = objectAnon ? new RDFResourceBlankNode(object) : new RDFResourceIRI(object);
    }

    public RDFTriple(IRI subject, boolean subjectAnon, IRI predicate, boolean predicateAnon, OWLLiteral object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException("RDF Triple must contain three elements");
        }
        this.subject = subjectAnon ? new RDFResourceBlankNode(subject) : new RDFResourceIRI(subject);
        this.predicate = new RDFResourceIRI(predicate);
        this.object = new RDFLiteral(object);
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Deprecated
    public RDFResourceIRI getProperty() {
        return this.getPredicate();
    }

    public RDFNode getObject() {
        return this.object;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDFTriple)) {
            return false;
        }
        RDFTriple other = (RDFTriple)o;
        return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subject.toString());
        sb.append(" ");
        sb.append(this.predicate.toString());
        sb.append(" ");
        sb.append(this.object.toString());
        sb.append(".");
        return sb.toString();
    }
}

