/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;

public class RDFResourceBlankNode
extends RDFResource {
    private final IRI resource;

    public RDFResourceBlankNode(IRI resource) {
        this.resource = resource;
    }

    public RDFResourceBlankNode(int anonId) {
        this.resource = IRI.create("_:genid" + Integer.toString(anonId));
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDFResourceBlankNode)) {
            return false;
        }
        RDFResourceBlankNode other = (RDFResourceBlankNode)o;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        if (!this.resource.toString().startsWith("_:")) {
            return "_:" + this.resource.toString();
        }
        return this.resource.toString();
    }

    @Override
    public IRI getIRI() {
        return this.resource;
    }

    @Override
    public IRI getResource() {
        return this.getIRI();
    }
}

