/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.github.ansell.abstractserviceloader.AbstractServiceLoader;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.rio.RDFFormat;
import org.semanticweb.owlapi.formats.OWLOntologyFormatFactory;
import org.semanticweb.owlapi.io.OWLParserFactory;

public class OWLParserFactoryRegistry
extends AbstractServiceLoader<OWLOntologyFormatFactory, OWLParserFactory> {
    private static final OWLParserFactoryRegistry instance = new OWLParserFactoryRegistry();

    public OWLParserFactoryRegistry() {
        super(OWLParserFactory.class);
    }

    public static OWLParserFactoryRegistry getInstance() {
        return instance;
    }

    public void clearParserFactories() {
        this.clear();
    }

    public List<OWLParserFactory> getParserFactories() {
        ArrayList all = new ArrayList(this.getAll());
        ArrayList<OWLParserFactory> list = new ArrayList<OWLParserFactory>(all.size());
        for (OWLParserFactory nextFactory : all) {
            if (!nextFactory.getFormatFactory().handlesMimeType(RDFFormat.RDFXML.getDefaultMIMEType())) continue;
            list.add(nextFactory);
        }
        for (OWLParserFactory nextFactory : all) {
            if (nextFactory.getFormatFactory().handlesMimeType(RDFFormat.RDFXML.getDefaultMIMEType())) continue;
            list.add(nextFactory);
        }
        return list;
    }

    public OWLParserFactory getParserFactory(String mimeType) {
        ArrayList all = new ArrayList(this.getAll());
        for (OWLParserFactory nextFactory : all) {
            if (!nextFactory.getFormatFactory().handlesMimeType(mimeType)) continue;
            return nextFactory;
        }
        return null;
    }

    public OWLParserFactory getParserFactory(OWLOntologyFormatFactory referenceFactory) {
        ArrayList all = new ArrayList(this.getAll());
        for (OWLParserFactory nextFactory : all) {
            if (!nextFactory.getFormatFactory().equals(referenceFactory)) continue;
            return nextFactory;
        }
        return null;
    }

    public void registerParserFactory(OWLParserFactory parserFactory) {
        this.add(parserFactory);
    }

    public void unregisterParserFactory(OWLParserFactory parserFactory) {
        this.remove(parserFactory);
    }

    protected OWLOntologyFormatFactory getKey(OWLParserFactory service) {
        return service.getFormatFactory();
    }
}

