/*
 * Decompiled with CFR 0.152.
 */
package com.franz.util;

import com.franz.util.Closeable;
import com.hp.hpl.jena.rdf.model.Model;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Closer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Closer.class);
    private final List toClose = Collections.synchronizedList(new LinkedList());
    private static final Closer singleton = new Closer();

    public <Obj> Obj closeLater(Obj o) {
        this.toClose.add(0, o);
        return o;
    }

    public boolean remove(Object o) {
        boolean removed = false;
        while (this.toClose.remove(o)) {
            removed = true;
        }
        return removed;
    }

    @Override
    public void close() {
        try {
            while (!this.toClose.isEmpty()) {
                this.close((java.io.Closeable)this.toClose.get(0));
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Collection closeAll(Collection objects) {
        for (Object object : objects) {
            this.close((java.io.Closeable)object);
        }
        return null;
    }

    public String toString() {
        return "{" + super.toString() + " toClose=" + this.toClose.size() + "}";
    }

    public <Obj> Obj close(Obj o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Closeable) {
            return (Obj)this.close((java.io.Closeable)((Object)((Closeable)o)));
        }
        if (o instanceof java.io.Closeable) {
            return (Obj)this.close((java.io.Closeable)o);
        }
        if (o instanceof CloseableIteration) {
            return (Obj)this.close((CloseableIteration)o);
        }
        if (o instanceof XMLStreamReader) {
            return (Obj)this.close((XMLStreamReader)o);
        }
        if (o instanceof MultiThreadedHttpConnectionManager) {
            return (Obj)this.close((MultiThreadedHttpConnectionManager)o);
        }
        if (o instanceof SimpleHttpConnectionManager) {
            return (Obj)this.close((SimpleHttpConnectionManager)o);
        }
        return this.closeReflection(o);
    }

    public <Obj> Obj handleCloseException(Obj o, Throwable e) {
        log.warn("ignoring error with close: " + o, e);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <CloseableType extends Closeable> CloseableType close(CloseableType o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                CloseableType CloseableType = this.handleCloseException(o, e);
                return CloseableType;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <CloseableType extends java.io.Closeable> CloseableType close(CloseableType o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                CloseableType CloseableType = this.handleCloseException(o, e);
                return CloseableType;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiThreadedHttpConnectionManager close(MultiThreadedHttpConnectionManager o) {
        if (o != null) {
            try {
                o.shutdown();
            }
            catch (Exception e) {
                MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = this.handleCloseException(o, e);
                return multiThreadedHttpConnectionManager;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleHttpConnectionManager close(SimpleHttpConnectionManager o) {
        if (o != null) {
            try {
                o.shutdown();
            }
            catch (Exception e) {
                SimpleHttpConnectionManager simpleHttpConnectionManager = this.handleCloseException(o, e);
                return simpleHttpConnectionManager;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Elem, Exc extends Exception> CloseableIteration<Elem, Exc> close(CloseableIteration<Elem, Exc> o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                CloseableIteration<Elem, Exc> closeableIteration = this.handleCloseException(o, e);
                return closeableIteration;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLStreamReader close(XMLStreamReader o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                XMLStreamReader xMLStreamReader = this.handleCloseException(o, e);
                return xMLStreamReader;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model close(Model o) {
        if (o != null) {
            try {
                o.close();
            }
            catch (Exception e) {
                Model model = this.handleCloseException(o, e);
                return model;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Obj> Obj closeReflection(Obj o) {
        if (o != null) {
            try {
                o.getClass().getMethod("close", new Class[0]).invoke(o, new Object[0]);
            }
            catch (Exception e) {
                Obj Obj = this.handleCloseException(o, e);
                return Obj;
            }
            finally {
                this.remove(o);
            }
        }
        return null;
    }

    public static <CloseableType extends Closeable> CloseableType Close(CloseableType o) {
        return singleton.close(o);
    }

    public static <CloseableType extends java.io.Closeable> CloseableType Close(CloseableType o) {
        return singleton.close(o);
    }

    public static MultiThreadedHttpConnectionManager Close(MultiThreadedHttpConnectionManager o) {
        return singleton.close(o);
    }

    public static SimpleHttpConnectionManager Close(SimpleHttpConnectionManager o) {
        return singleton.close(o);
    }

    public static <Elem, Exc extends Exception> CloseableIteration<Elem, Exc> Close(CloseableIteration<Elem, Exc> o) {
        return singleton.close(o);
    }

    public static XMLStreamReader Close(XMLStreamReader o) {
        return singleton.close(o);
    }

    public static Model Close(Model o) {
        return singleton.close(o);
    }

    public static <Obj> Obj Close(Obj o) {
        return singleton.close((java.io.Closeable)o);
    }
}

