/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository.config;

import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.config.AGRepositoryConfig;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryFactory;
import org.openrdf.repository.config.RepositoryImplConfig;

public class AGRepositoryFactory
implements RepositoryFactory {
    public static final String REPOSITORY_TYPE = "allegrograph:AGRepository";

    public String getRepositoryType() {
        return REPOSITORY_TYPE;
    }

    public AGRepositoryConfig getConfig() {
        return new AGRepositoryConfig();
    }

    public Repository getRepository(RepositoryImplConfig config) throws RepositoryConfigException {
        AGRepository result = null;
        if (config instanceof AGRepositoryConfig) {
            AGRepositoryConfig agconfig = (AGRepositoryConfig)config;
            AGServer server = new AGServer(agconfig.getServerUrl(), agconfig.getUsername(), agconfig.getPassword());
            try {
                result = server.createCatalog(agconfig.getCatalogId()).createRepository(agconfig.getRepositoryId());
            }
            catch (RepositoryException e) {
                throw new RepositoryConfigException((Throwable)e);
            }
        } else {
            throw new RepositoryConfigException("Invalid configuration class: " + config.getClass());
        }
        return result;
    }
}

