/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository.config;

import com.franz.agraph.repository.config.AGRepositorySchema;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class AGRepositoryConfig
extends RepositoryImplConfigBase {
    private String serverUrl;
    private String username;
    private String password;
    private String catalogId;
    private String repositoryId;

    public AGRepositoryConfig() {
        super("allegrograph:AGRepository");
    }

    public AGRepositoryConfig(String url) {
        this();
        this.setServerUrl(url);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.serverUrl == null) {
            throw new RepositoryConfigException("No serverUrl specified for AG repositoryId");
        }
        if (this.username == null) {
            throw new RepositoryConfigException("No username specified for AG repositoryId");
        }
        if (this.password == null) {
            throw new RepositoryConfigException("No password specified for AG repositoryId");
        }
        if (this.catalogId == null) {
            throw new RepositoryConfigException("No catalogId specified for AG repositoryId");
        }
        if (this.repositoryId == null) {
            throw new RepositoryConfigException("No repositoryId specified for AG repositoryId");
        }
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.serverUrl != null) {
            graph.add(implNode, AGRepositorySchema.SERVERURL, (Value)graph.getValueFactory().createURI(this.serverUrl), new Resource[0]);
        }
        if (this.username != null) {
            graph.add(implNode, AGRepositorySchema.USERNAME, (Value)graph.getValueFactory().createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            graph.add(implNode, AGRepositorySchema.PASSWORD, (Value)graph.getValueFactory().createLiteral(this.password), new Resource[0]);
        }
        if (this.catalogId != null) {
            graph.add(implNode, AGRepositorySchema.CATALOGID, (Value)graph.getValueFactory().createLiteral(this.catalogId), new Resource[0]);
        }
        if (this.repositoryId != null) {
            graph.add(implNode, AGRepositorySchema.REPOSITORYID, (Value)graph.getValueFactory().createLiteral(this.repositoryId), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal repositoryId;
            Literal catalogId;
            Literal password;
            Literal username;
            URI uri = GraphUtil.getOptionalObjectURI((Graph)graph, (Resource)implNode, (URI)AGRepositorySchema.SERVERURL);
            if (uri != null) {
                this.setServerUrl(uri.toString());
            }
            if ((username = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)AGRepositorySchema.USERNAME)) != null) {
                this.setUsername(username.getLabel());
            }
            if ((password = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)AGRepositorySchema.PASSWORD)) != null) {
                this.setPassword(password.getLabel());
            }
            if ((catalogId = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)AGRepositorySchema.CATALOGID)) != null) {
                this.setCatalogId(catalogId.getLabel());
            }
            if ((repositoryId = GraphUtil.getOptionalObjectLiteral((Graph)graph, (Resource)implNode, (URI)AGRepositorySchema.REPOSITORYID)) != null) {
                this.setRepositoryId(repositoryId.getLabel());
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

