/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.exception.AGMalformedDataException;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGFormattedNamespace;
import com.franz.agraph.repository.AGFreetextIndexConfig;
import com.franz.agraph.repository.AGGraphQuery;
import com.franz.agraph.repository.AGMaterializer;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGQueryLanguage;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGSpinFunction;
import com.franz.agraph.repository.AGSpinMagicProperty;
import com.franz.agraph.repository.AGStreamTupleQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGUpdate;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.agraph.repository.AGVirtualRepository;
import com.franz.util.Closeable;
import com.franz.util.Closer;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIteratorIteration;
import info.aduna.iteration.Iteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openrdf.OpenRDFException;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.Update;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.StatementCollector;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class AGRepositoryConnection
extends RepositoryConnectionBase
implements RepositoryConnection,
Closeable {
    private final AGAbstractRepository repository;
    private final AGHttpRepoClient repoclient;
    private boolean streamResults;
    private final AGValueFactory vf;

    public AGRepositoryConnection(AGRepository repository, AGHttpRepoClient client) {
        super((Repository)repository);
        this.repository = repository;
        this.repoclient = client;
        this.setStreamResults("true".equals(System.getProperty("com.franz.agraph.repository.AGRepositoryConnection.streamResults")));
        this.vf = new AGValueFactory(repository, this);
    }

    public AGRepositoryConnection(AGVirtualRepository repository, AGHttpRepoClient client) {
        super((Repository)repository);
        this.repository = repository;
        this.repoclient = client;
        this.setStreamResults("true".equals(System.getProperty("com.franz.agraph.repository.AGRepositoryConnection.streamResults")));
        this.vf = new AGValueFactory(repository.wrapped, this);
    }

    public String toString() {
        return "{" + super.toString() + " " + this.repoclient + "}";
    }

    public AGAbstractRepository getRepository() {
        return this.repository;
    }

    public AGHttpRepoClient getHttpRepoClient() {
        return this.repoclient;
    }

    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        StatementImpl st = new StatementImpl(subject, predicate, object);
        JSONArray rows = this.encodeJSON((Statement)st, contexts);
        try {
            this.getHttpRepoClient().uploadJSON(rows, new Resource[0]);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            JSONArray rows_st = this.encodeJSON(statement, new Resource[0]);
            this.append(rows, rows_st);
        }
        try {
            this.getHttpRepoClient().uploadJSON(rows, contexts);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    private void append(JSONArray rows, JSONArray rowsSt) {
        for (int i = 0; i < rowsSt.length(); ++i) {
            try {
                rows.put(rowsSt.get(i));
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statementIter.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statementIter.next(), contexts));
        }
        try {
            this.getHttpRepoClient().uploadJSON(rows, new Resource[0]);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    private JSONArray encodeJSON(Statement st, Resource ... contexts) {
        JSONArray rows = new JSONArray();
        if (contexts.length == 0) {
            JSONArray row = new JSONArray().put((Object)this.encodeValueForStorageJSON((Value)st.getSubject())).put((Object)this.encodeValueForStorageJSON((Value)st.getPredicate())).put((Object)this.encodeValueForStorageJSON(st.getObject()));
            if (st.getContext() != null) {
                row.put((Object)this.encodeValueForStorageJSON((Value)st.getContext()));
            }
            rows.put((Object)row);
        } else {
            for (Resource c : contexts) {
                JSONArray row = new JSONArray().put((Object)this.encodeValueForStorageJSON((Value)st.getSubject())).put((Object)this.encodeValueForStorageJSON((Value)st.getPredicate())).put((Object)this.encodeValueForStorageJSON(st.getObject()));
                if (c != null) {
                    row.put((Object)this.encodeValueForStorageJSON((Value)c));
                }
                rows.put((Object)row);
            }
        }
        return rows;
    }

    private String encodeValueForStorageJSON(Value v) {
        return NTriplesUtil.toNTriplesString((Value)this.repoclient.getStorableValue(v, this.vf));
    }

    protected void addInputStreamOrReader(Object inputStreamOrReader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (inputStreamOrReader instanceof InputStream) {
            try {
                this.getHttpRepoClient().upload((InputStream)inputStreamOrReader, baseURI, dataFormat, false, contexts);
            }
            catch (AGMalformedDataException e) {
                throw new RDFParseException((Throwable)((Object)e));
            }
        } else if (inputStreamOrReader instanceof Reader) {
            try {
                this.getHttpRepoClient().upload((Reader)inputStreamOrReader, baseURI, dataFormat, false, contexts);
            }
            catch (AGMalformedDataException e) {
                throw new RDFParseException((Throwable)((Object)e));
            }
        } else {
            throw new IllegalArgumentException("inputStreamOrReader must be an InputStream or a Reader, is a: " + inputStreamOrReader.getClass());
        }
    }

    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.getHttpRepoClient().deleteStatements(subject, predicate, object, contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        for (Statement statement : statements) {
            this.append(rows, this.encodeJSON(statement, contexts));
        }
        this.getHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        JSONArray rows = new JSONArray();
        while (statements.hasNext()) {
            this.append(rows, this.encodeJSON((Statement)statements.next(), contexts));
        }
        this.getHttpRepoClient().deleteJSON(rows, new Resource[0]);
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        this.getHttpRepoClient().setAutoCommit(autoCommit);
    }

    public boolean isAutoCommit() throws RepositoryException {
        return this.getHttpRepoClient().isAutoCommit();
    }

    public void commit() throws RepositoryException {
        this.getHttpRepoClient().commit();
    }

    public void rollback() throws RepositoryException {
        this.getHttpRepoClient().rollback();
    }

    public void setStreamResults(boolean streamResults) {
        this.streamResults = streamResults;
    }

    public boolean isStreamResults() {
        return this.streamResults;
    }

    protected void autoCommit() throws RepositoryException {
    }

    public void clearNamespaces() throws RepositoryException {
        this.getHttpRepoClient().clearNamespaces();
    }

    @Override
    public void close() throws RepositoryException {
        if (this.isOpen()) {
            this.getHttpRepoClient().close();
            super.close();
        }
    }

    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, RepositoryException {
        this.getHttpRepoClient().getStatements(subj, pred, obj, Boolean.toString(includeInferred), handler, contexts);
    }

    public void exportStatements(RDFHandler handler, String ... ids) throws RDFHandlerException, RepositoryException {
        this.getHttpRepoClient().getStatements(handler, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            ArrayList<Resource> contextList = new ArrayList<Resource>();
            TupleQueryResult contextIDs = this.getHttpRepoClient().getContextIDs();
            try {
                while (contextIDs.hasNext()) {
                    BindingSet bindingSet = (BindingSet)contextIDs.next();
                    Value context = bindingSet.getValue("contextID");
                    if (!(context instanceof Resource)) continue;
                    contextList.add((Resource)context);
                }
            }
            finally {
                contextIDs.close();
            }
            return this.createRepositoryResult(contextList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public <E> RepositoryResult<E> createRepositoryResult(Iterable<? extends E> elements) {
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(elements.iterator()));
    }

    public String getNamespace(String prefix) throws RepositoryException {
        return this.getHttpRepoClient().getNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            ArrayList<NamespaceImpl> namespaceList = new ArrayList<NamespaceImpl>();
            TupleQueryResult namespaces = this.getHttpRepoClient().getNamespaces();
            try {
                while (namespaces.hasNext()) {
                    BindingSet bindingSet = (BindingSet)namespaces.next();
                    Value prefix = bindingSet.getValue("prefix");
                    Value namespace = bindingSet.getValue("namespace");
                    if (!(prefix instanceof Literal) || !(namespace instanceof Literal)) continue;
                    String prefixStr = ((Literal)prefix).getLabel();
                    String namespaceStr = ((Literal)namespace).getLabel();
                    namespaceList.add(new NamespaceImpl(prefixStr, namespaceStr));
                }
            }
            finally {
                namespaces.close();
            }
            return this.createRepositoryResult(namespaceList);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements(subj, pred, obj, includeInferred, (RDFHandler)collector, contexts);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositoryResult<Statement> getStatements(String ... ids) throws RepositoryException {
        try {
            StatementCollector collector = new StatementCollector();
            this.exportStatements((RDFHandler)collector, ids);
            return this.createRepositoryResult(collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public AGQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) {
        if (QueryLanguage.SPARQL.equals((Object)ql)) {
            String strippedQuery = this.stripSparqlQueryString(queryString).toUpperCase();
            if (strippedQuery.startsWith("SELECT")) {
                return this.prepareTupleQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("ASK")) {
                return this.prepareBooleanQuery(ql, queryString, baseURI);
            }
            if (strippedQuery.startsWith("CONSTRUCT") || strippedQuery.startsWith("DESCRIBE")) {
                return this.prepareGraphQuery(ql, queryString, baseURI);
            }
            throw new IllegalArgumentException("Unable to determine a query type (Tuple, Graph, Boolean) for the query:\n" + queryString);
        }
        if (AGQueryLanguage.PROLOG.equals(ql)) {
            return this.prepareTupleQuery(ql, queryString, baseURI);
        }
        throw new UnsupportedOperationException("Operation not supported for query language " + ql);
    }

    private String stripSparqlQueryString(String queryString) {
        String normalizedQuery = queryString;
        Pattern pattern = Pattern.compile("prefix[^:]+:\\s*<[^>]*>\\s*", 2);
        Matcher matcher = pattern.matcher(queryString);
        int startIndexCorrection = 0;
        while (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end() - startIndexCorrection, normalizedQuery.length());
            startIndexCorrection += matcher.end() - startIndexCorrection;
        }
        pattern = Pattern.compile("base\\s+<[^>]*>\\s*", 2);
        matcher = pattern.matcher(normalizedQuery);
        if (matcher.find()) {
            normalizedQuery = normalizedQuery.substring(matcher.end(), normalizedQuery.length());
        }
        pattern = Pattern.compile("\\s*#.*", 2);
        matcher = pattern.matcher(normalizedQuery);
        normalizedQuery = matcher.replaceAll("");
        return normalizedQuery.trim();
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString) {
        return this.prepareTupleQuery(ql, queryString, null);
    }

    public AGTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGTupleQuery q = new AGTupleQuery(this, ql, queryString, baseURI);
        q.prepare();
        if (this.streamResults) {
            q = new AGStreamTupleQuery(q);
        }
        return q;
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString) {
        return this.prepareGraphQuery(ql, queryString, null);
    }

    public AGGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGGraphQuery q = new AGGraphQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString) {
        return this.prepareBooleanQuery(ql, queryString, null);
    }

    public AGBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) {
        AGBooleanQuery q = new AGBooleanQuery(this, ql, queryString, baseURI);
        q.prepare();
        return q;
    }

    public Update prepareUpdate(QueryLanguage ql, String queryString, String baseURI) {
        AGUpdate u = new AGUpdate(this, ql, queryString, baseURI);
        u.prepare();
        return u;
    }

    public Update prepareUpdate(QueryLanguage ql, String queryString) {
        AGUpdate u = new AGUpdate(this, ql, queryString, null);
        u.prepare();
        return u;
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        this.getHttpRepoClient().removeNamespacePrefix(prefix);
    }

    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.getHttpRepoClient().setNamespacePrefix(prefix, name);
    }

    public long size(Resource ... contexts) throws RepositoryException {
        return this.getHttpRepoClient().size(contexts);
    }

    public void createFreetextIndex(String indexName, AGFreetextIndexConfig config) throws RepositoryException {
        ArrayList<String> predicates = new ArrayList<String>();
        for (URI uri : config.getPredicates()) {
            predicates.add(NTriplesUtil.toNTriplesString((URI)uri));
        }
        this.getHttpRepoClient().createFreetextIndex(indexName, predicates, config.getIndexLiterals(), config.getIndexLiteralTypes(), config.getIndexResources(), config.getIndexFields(), config.getMinimumWordSize(), config.getStopWords(), config.getWordFilters(), config.getInnerChars(), config.getBorderChars(), config.getTokenizer());
    }

    public void deleteFreetextIndex(String indexName) throws RepositoryException {
        this.getHttpRepoClient().deleteFreetextIndex(indexName);
    }

    public void createFreetextIndex(String name, URI[] predicates) throws RepositoryException {
        AGFreetextIndexConfig config = AGFreetextIndexConfig.newInstance();
        config.getPredicates().addAll(Arrays.asList(predicates));
        this.createFreetextIndex(name, config);
    }

    public String[] getFreetextPredicates(String index) throws RepositoryException {
        return this.getHttpRepoClient().getFreetextPredicates(index);
    }

    public AGFreetextIndexConfig getFreetextIndexConfig(String indexName) throws RepositoryException {
        return new AGFreetextIndexConfig(this.getHttpRepoClient().getFreetextIndexConfiguration(indexName));
    }

    public String[] getFreetextIndices() throws RepositoryException {
        return this.getHttpRepoClient().getFreetextIndices();
    }

    public List<String> listFreetextIndices() throws RepositoryException {
        return this.getHttpRepoClient().listFreetextIndices();
    }

    public void registerPredicateMapping(URI predicate, URI primtype) throws RepositoryException {
        this.getHttpRepoClient().registerPredicateMapping(predicate, primtype);
    }

    public void deletePredicateMapping(URI predicate) throws RepositoryException {
        this.getHttpRepoClient().deletePredicateMapping(predicate);
    }

    public String[] getPredicateMappings() throws RepositoryException {
        return this.getHttpRepoClient().getPredicateMappings();
    }

    public void registerDatatypeMapping(URI datatype, URI primtype) throws RepositoryException {
        this.getHttpRepoClient().registerDatatypeMapping(datatype, primtype);
    }

    public void deleteDatatypeMapping(URI datatype) throws RepositoryException {
        this.getHttpRepoClient().deleteDatatypeMapping(datatype);
    }

    public String[] getDatatypeMappings() throws RepositoryException {
        return this.getHttpRepoClient().getDatatypeMappings();
    }

    public void clearMappings() throws RepositoryException {
        this.getHttpRepoClient().clearMappings();
    }

    public void clearMappings(boolean includeAutoEncodedPrimitiveTypes) throws RepositoryException {
        this.getHttpRepoClient().clearMappings(includeAutoEncodedPrimitiveTypes);
    }

    public void addRules(String rules) throws RepositoryException {
        this.getHttpRepoClient().addRules(rules);
    }

    public void addRules(InputStream rulestream) throws RepositoryException {
        this.getHttpRepoClient().addRules(rulestream);
    }

    public String evalInServer(String lispForm) throws RepositoryException {
        return this.getHttpRepoClient().evalInServer(lispForm);
    }

    public String evalInServer(InputStream stream) throws RepositoryException {
        return this.getHttpRepoClient().evalInServer(stream);
    }

    public void load(URI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        this.getHttpRepoClient().load(source, baseURI, dataFormat, contexts);
    }

    public void load(String absoluteServerPath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException {
        this.getHttpRepoClient().load(absoluteServerPath, baseURI, dataFormat, contexts);
    }

    public void ping() throws RepositoryException {
        this.getHttpRepoClient().ping();
    }

    public String[] getGeoTypes() throws RepositoryException {
        return this.getHttpRepoClient().getGeoTypes();
    }

    public URI registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws RepositoryException {
        String nTriplesURI = this.getHttpRepoClient().registerCartesianType(stripWidth, xmin, xmax, ymin, ymax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public URI registerSphericalType(float stripWidth, String unit, float latmin, float lonmin, float latmax, float lonmax) throws RepositoryException {
        String nTriplesURI = this.getHttpRepoClient().registerSphericalType(stripWidth, unit, latmin, lonmin, latmax, lonmax);
        return NTriplesUtil.parseURI((String)nTriplesURI, (ValueFactory)this.getValueFactory());
    }

    public URI registerSphericalType(float stripWidth, String unit) throws RepositoryException {
        return this.registerSphericalType(stripWidth, unit, -90.0f, -180.0f, 90.0f, 180.0f);
    }

    public void registerPolygon(URI polygon, List<Literal> points) throws RepositoryException {
        ArrayList<String> nTriplesPoints = new ArrayList<String>(points.size());
        for (Literal point : points) {
            nTriplesPoints.add(NTriplesUtil.toNTriplesString((Literal)point));
        }
        this.getHttpRepoClient().registerPolygon(NTriplesUtil.toNTriplesString((URI)polygon), nTriplesPoints);
    }

    public RepositoryResult<Statement> getStatementsInBox(URI type, URI predicate, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.getHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.getHttpRepoClient().getAllowExternalBlankNodeIds());
        this.getHttpRepoClient().getGeoBox(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), xmin, xmax, ymin, ymax, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInCircle(URI type, URI predicate, float x, float y, float radius, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.getHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.getHttpRepoClient().getAllowExternalBlankNodeIds());
        this.getHttpRepoClient().getGeoCircle(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), x, y, radius, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getGeoHaversine(URI type, URI predicate, float lat, float lon, float radius, String unit, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.getHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.getHttpRepoClient().getAllowExternalBlankNodeIds());
        this.getHttpRepoClient().getGeoHaversine(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), lat, lon, radius, unit, limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public RepositoryResult<Statement> getStatementsInPolygon(URI type, URI predicate, URI polygon, int limit, boolean infer) throws RepositoryException {
        StatementCollector collector = new StatementCollector();
        AGRDFHandler handler = new AGRDFHandler(this.getHttpRepoClient().getPreferredRDFFormat(), (RDFHandler)collector, this.getValueFactory(), this.getHttpRepoClient().getAllowExternalBlankNodeIds());
        this.getHttpRepoClient().getGeoPolygon(NTriplesUtil.toNTriplesString((URI)type), NTriplesUtil.toNTriplesString((URI)predicate), NTriplesUtil.toNTriplesString((URI)polygon), limit, infer, handler);
        return this.createRepositoryResult(collector.getStatements());
    }

    public void registerSNAGenerator(String generator, List<URI> objectOfs, List<URI> subjectOfs, List<URI> undirecteds, String query) throws RepositoryException {
        ArrayList<String> objOfs = new ArrayList<String>();
        if (objectOfs != null) {
            for (URI objectOf : objectOfs) {
                objOfs.add(NTriplesUtil.toNTriplesString((URI)objectOf));
            }
        }
        ArrayList<String> subjOfs = new ArrayList<String>();
        if (subjectOfs != null) {
            for (URI subjectOf : subjectOfs) {
                subjOfs.add(NTriplesUtil.toNTriplesString((URI)subjectOf));
            }
        }
        ArrayList<String> undirs = new ArrayList<String>();
        if (undirecteds != null) {
            for (URI undirected : undirecteds) {
                undirs.add(NTriplesUtil.toNTriplesString((URI)undirected));
            }
        }
        this.getHttpRepoClient().registerSNAGenerator(generator, objOfs, subjOfs, undirs, query);
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<URI> group, int depth) throws RepositoryException {
        if (group == null || group.size() == 0) {
            throw new IllegalArgumentException("group must be non-empty.");
        }
        ArrayList<String> grp = new ArrayList<String>(3);
        for (URI node : group) {
            grp.add(NTriplesUtil.toNTriplesString((URI)node));
        }
        this.getHttpRepoClient().registerSNANeighborMatrix(matrix, generator, grp, depth);
    }

    public List<String> listIndices() throws OpenRDFException {
        return this.getHttpRepoClient().listIndices(false);
    }

    public List<String> listValidIndices() throws OpenRDFException {
        return this.getHttpRepoClient().listIndices(true);
    }

    public void addIndex(String type) throws RepositoryException {
        this.getHttpRepoClient().addIndex(type);
    }

    public void dropIndex(String type) throws RepositoryException {
        this.getHttpRepoClient().dropIndex(type);
    }

    public void sendRDFTransaction(InputStream rdftransaction) throws RepositoryException, RDFParseException, IOException {
        try {
            this.getHttpRepoClient().sendRDFTransaction(rdftransaction);
        }
        catch (AGMalformedDataException e) {
            throw new RDFParseException((Throwable)((Object)e));
        }
    }

    public void registerEncodableNamespace(String namespace, String format) throws RepositoryException {
        this.getHttpRepoClient().registerEncodableNamespace(namespace, format);
    }

    public void registerEncodableNamespaces(Iterable<? extends AGFormattedNamespace> formattedNamespaces) throws RepositoryException {
        JSONArray rows = new JSONArray();
        for (AGFormattedNamespace aGFormattedNamespace : formattedNamespaces) {
            JSONObject row = new JSONObject();
            try {
                row.put("prefix", (Object)aGFormattedNamespace.getNamespace());
                row.put("format", (Object)aGFormattedNamespace.getFormat());
            }
            catch (JSONException e) {
                throw new RepositoryException((Throwable)e);
            }
            rows.put((Object)row);
        }
        this.getHttpRepoClient().registerEncodableNamespaces(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AGFormattedNamespace> listEncodableNamespaces() throws OpenRDFException {
        TupleQueryResult tqresult = this.getHttpRepoClient().getEncodableNamespaces();
        ArrayList<AGFormattedNamespace> result = new ArrayList<AGFormattedNamespace>();
        try {
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value prefix = bindingSet.getValue("prefix");
                Value format = bindingSet.getValue("format");
                result.add(new AGFormattedNamespace(prefix.stringValue(), format.stringValue()));
            }
        }
        finally {
            tqresult.close();
        }
        return result;
    }

    public void unregisterEncodableNamespace(String namespace) throws RepositoryException {
        this.getHttpRepoClient().unregisterEncodableNamespace(namespace);
    }

    public Object callStoredProc(String functionName, String moduleName, Object ... args) throws RepositoryException {
        return this.getHttpRepoClient().callStoredProc(functionName, moduleName, args);
    }

    public void setSessionLifetime(int lifetimeInSeconds) {
        this.getHttpRepoClient().setSessionLifetime(lifetimeInSeconds);
    }

    public int getSessionLifetime() {
        return this.getHttpRepoClient().getSessionLifetime();
    }

    public void setSessionLoadInitFile(boolean loadInitFile) {
        this.getHttpRepoClient().setSessionLoadInitFile(loadInitFile);
    }

    public void addSessionLoadScript(String scriptName) {
        this.getHttpRepoClient().addSessionLoadScript(scriptName);
    }

    public void enableTripleCache(long size) throws RepositoryException {
        this.getHttpRepoClient().enableTripleCache(size);
    }

    public long getTripleCacheSize() throws RepositoryException {
        return this.getHttpRepoClient().getTripleCacheSize();
    }

    public void disableTripleCache() throws RepositoryException {
        this.getHttpRepoClient().disableTripleCache();
    }

    public void setUploadCommitPeriod(int period) throws RepositoryException {
        this.getHttpRepoClient().setUploadCommitPeriod(period);
    }

    public int getUploadCommitPeriod() throws RepositoryException {
        return this.getHttpRepoClient().getUploadCommitPeriod();
    }

    public void optimizeIndices(Boolean wait, int level) throws RepositoryException {
        this.getHttpRepoClient().optimizeIndices(wait, level);
    }

    public void optimizeIndices(Boolean wait) throws RepositoryException {
        this.getHttpRepoClient().optimizeIndices(wait);
    }

    public String getSpinFunction(String uri) throws OpenRDFException {
        return this.getHttpRepoClient().getSpinFunction(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AGSpinFunction> listSpinFunctions() throws OpenRDFException {
        TupleQueryResult list = this.getHttpRepoClient().listSpinFunctions();
        try {
            ArrayList<AGSpinFunction> result = new ArrayList<AGSpinFunction>();
            while (list.hasNext()) {
                result.add(new AGSpinFunction((BindingSet)list.next()));
            }
            ArrayList<AGSpinFunction> arrayList = result;
            return arrayList;
        }
        finally {
            Closer.Close(list);
        }
    }

    public void putSpinFunction(AGSpinFunction fn) throws OpenRDFException {
        this.getHttpRepoClient().putSpinFunction(fn);
    }

    public void deleteSpinFunction(String uri) throws OpenRDFException {
        this.getHttpRepoClient().deleteSpinFunction(uri);
    }

    public String getSpinMagicProperty(String uri) throws OpenRDFException {
        return this.getHttpRepoClient().getSpinMagicProperty(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AGSpinMagicProperty> listSpinMagicProperties() throws OpenRDFException {
        TupleQueryResult list = this.getHttpRepoClient().listSpinMagicProperties();
        try {
            ArrayList<AGSpinMagicProperty> result = new ArrayList<AGSpinMagicProperty>();
            while (list.hasNext()) {
                result.add(new AGSpinMagicProperty((BindingSet)list.next()));
            }
            ArrayList<AGSpinMagicProperty> arrayList = result;
            return arrayList;
        }
        finally {
            Closer.Close(list);
        }
    }

    public void deleteSpinMagicProperty(String uri) throws OpenRDFException {
        this.getHttpRepoClient().deleteSpinMagicProperty(uri);
    }

    public void putSpinMagicProperty(AGSpinMagicProperty fn) throws OpenRDFException {
        this.getHttpRepoClient().putSpinMagicProperty(fn);
    }

    public void deleteDuplicates(String comparisonMode) throws RepositoryException {
        this.getHttpRepoClient().deleteDuplicates(comparisonMode);
    }

    public long materialize(AGMaterializer materializer) throws RepositoryException {
        return this.getHttpRepoClient().materialize(materializer);
    }

    public long deleteMaterialized() throws RepositoryException {
        return this.getHttpRepoClient().deleteMaterialized();
    }

    public void setMasqueradeAsUser(String user) throws RepositoryException {
        this.repoclient.setMasqueradeAsUser(user);
    }
}

