/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import java.io.File;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;

public class AGRepository
extends RepositoryBase
implements AGAbstractRepository {
    private final AGCatalog catalog;
    private final String repositoryID;
    private final String catalogPrefixedRepositoryID;
    private final String repositoryURL;
    private final AGValueFactory vf;

    public AGRepository(AGCatalog catalog, String repositoryID) {
        this.catalog = catalog;
        this.repositoryID = repositoryID;
        this.catalogPrefixedRepositoryID = catalog.getCatalogPrefixedRepositoryID(repositoryID);
        this.repositoryURL = catalog.getRepositoryURL(repositoryID);
        this.vf = new AGValueFactory(this);
    }

    @Override
    public AGCatalog getCatalog() {
        return this.catalog;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public String getCatalogPrefixedRepositoryID() {
        return this.catalogPrefixedRepositoryID;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    @Override
    public AGValueFactory getValueFactory() {
        return this.vf;
    }

    public AGHTTPClient getHTTPClient() {
        return this.getCatalog().getHTTPClient();
    }

    protected void initializeInternal() throws RepositoryException {
    }

    @Override
    public AGRepositoryConnection getConnection() throws RepositoryException {
        AGHttpRepoClient repoclient = new AGHttpRepoClient(this, this.getCatalog().getHTTPClient(), this.repositoryURL, null);
        return new AGRepositoryConnection(this, repoclient);
    }

    public boolean isWritable() throws RepositoryException {
        String url = this.getCatalog().getRepositoriesURL();
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        Value writable = null;
        try {
            while (null == writable && tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value uri = bindingSet.getValue("uri");
                if (!uri.stringValue().equals(this.getRepositoryURL())) continue;
                writable = bindingSet.getValue("writable");
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                tqresult.close();
            }
            catch (QueryEvaluationException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (null == writable) {
            throw new IllegalStateException("Repository not found in catalog's list of repositories: " + this.getRepositoryURL());
        }
        boolean result = Boolean.parseBoolean(writable.stringValue());
        return result;
    }

    @Override
    public String getSpec() {
        String cname = this.getCatalog().getCatalogName();
        String name = this.getRepositoryID();
        if (AGCatalog.isRootID(cname)) {
            return "<" + name + ">";
        }
        return "<" + cname + ":" + name + ">";
    }

    public File getDataDir() {
        return null;
    }

    public void setDataDir(File dataDir) {
    }

    protected void shutDownInternal() throws RepositoryException {
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    public void setBulkMode(boolean bulkMode) throws RepositoryException {
        String url = this.repositoryURL + "/bulkMode";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        try {
            if (bulkMode) {
                this.getHTTPClient().put(url, headers, data, null, null);
            } else {
                this.getHTTPClient().delete(url, headers, data, null);
            }
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public boolean isBulkMode() throws RepositoryException {
        try {
            return Boolean.parseBoolean(this.getHTTPClient().getString(this.repositoryURL + "/bulkMode"));
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void setDuplicateSuppressionPolicy(String policy) throws RepositoryException {
        String url = this.repositoryURL + "/suppressDuplicates";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("type", policy)};
        try {
            this.getHTTPClient().put(url, headers, data, null, null);
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public String getDuplicateSuppressionPolicy() throws RepositoryException {
        try {
            return this.getHTTPClient().getString(this.repositoryURL + "/suppressDuplicates");
        }
        catch (AGHttpException e) {
            throw new RepositoryException((Throwable)((Object)e));
        }
    }

    public void forceCheckpoint() throws RepositoryException {
        String url = this.repositoryURL + "/force-checkpoint";
        Header[] hdr = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        this.getHTTPClient().post(url, hdr, data, null, null);
    }

    public void ensureDBIdle() throws RepositoryException {
        String url = this.repositoryURL + "/ensure-db-idle";
        Header[] hdr = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        this.getHTTPClient().post(url, hdr, data, null, null);
    }
}

