/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGCustomStoredProcException;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGJSONHandler;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.http.storedproc.AGDeserializer;
import com.franz.agraph.http.storedproc.AGSerializer;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGMaterializer;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGRDFFormat;
import com.franz.agraph.repository.AGSpinFunction;
import com.franz.agraph.repository.AGSpinMagicProperty;
import com.franz.agraph.repository.AGUpdate;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import info.aduna.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openrdf.OpenRDFUtil;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.Binding;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHttpRepoClient
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static int defaultSessionLifetimeInSeconds = 3600;
    private int lifetimeInSeconds = defaultSessionLifetimeInSeconds;
    private boolean usingDedicatedSession = false;
    private boolean autoCommit = true;
    private int uploadCommitPeriod = 0;
    private String sessionRoot;
    private String repoRoot;
    private boolean loadInitFile = false;
    private List<String> scripts = null;
    private TupleQueryResultFormat preferredTQRFormat = TupleQueryResultFormat.SPARQL;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = this.getDefaultRDFFormat();
    private AGHTTPClient client;
    private AGAbstractRepository repo;
    public ConcurrentLinkedQueue<String> savedQueryDeleteQueue;
    private boolean allowExternalBlankNodeIds = false;

    public static long getDefaultSessionLifetime() {
        return defaultSessionLifetimeInSeconds;
    }

    public static void setDefaultSessionLifetime(int lifetimeInSeconds) {
        defaultSessionLifetimeInSeconds = lifetimeInSeconds;
    }

    public AGHttpRepoClient(AGAbstractRepository repo, AGHTTPClient client, String repoRoot, String sessionRoot) {
        this.repo = repo;
        this.sessionRoot = sessionRoot;
        this.repoRoot = repoRoot;
        this.client = client;
        this.savedQueryDeleteQueue = new ConcurrentLinkedQueue();
    }

    public String toString() {
        return "{" + super.toString() + " " + this.client + " rr=" + this.repoRoot + " sr=" + this.sessionRoot + "}";
    }

    public String getRoot() throws AGHttpException {
        if (this.sessionRoot != null) {
            return this.sessionRoot;
        }
        if (this.repoRoot != null) {
            return this.repoRoot;
        }
        throw new AGHttpException("This session-only connection has been closed. Re-open a new one to start using it again.");
    }

    public boolean usingMainPortForSessions() {
        boolean b = Boolean.parseBoolean(System.getProperty("com.franz.agraph.http.useMainPortForSessions", "false"));
        this.logger.debug("com.franz.agraph.http.useMainPortForSessions=" + b);
        return b;
    }

    public AGValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }

    public void setSessionLifetime(int lifetimeInSeconds) {
        this.lifetimeInSeconds = lifetimeInSeconds;
    }

    public int getSessionLifetime() {
        return this.lifetimeInSeconds;
    }

    public void setSessionLoadInitFile(boolean loadInitFile) {
        this.loadInitFile = loadInitFile;
    }

    public boolean getSessionLoadInitFile() {
        return this.loadInitFile;
    }

    public void addSessionLoadScript(String scriptName) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<String>();
        }
        this.scripts.add(scriptName);
    }

    public TupleQueryResultFormat getPreferredTQRFormat() {
        return this.preferredTQRFormat;
    }

    public void setPreferredTQRFormat(TupleQueryResultFormat preferredTQRFormat) {
        this.preferredTQRFormat = preferredTQRFormat;
    }

    public BooleanQueryResultFormat getPreferredBQRFormat() {
        return this.preferredBQRFormat;
    }

    public void setPreferredBQRFormat(BooleanQueryResultFormat preferredBQRFormat) {
        this.preferredBQRFormat = preferredBQRFormat;
    }

    public RDFFormat getDefaultRDFFormat() {
        RDFFormat format = System.getProperty("com.franz.agraph.http.defaultRDFFormat", "TRIX").equalsIgnoreCase("NQUADS") ? AGRDFFormat.NQUADS : RDFFormat.TRIX;
        this.logger.debug("Defaulting to " + format.getDefaultMIMEType() + " for requests that return RDF statements.");
        return format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredRDFFormat(RDFFormat preferredRDFFormat) {
        this.logger.debug("Defaulting to " + preferredRDFFormat.getDefaultMIMEType() + " for requests that return RDF statements.");
        this.preferredRDFFormat = preferredRDFFormat;
    }

    public String getServerURL() {
        return this.client.getServerURL();
    }

    public AGHTTPClient getHTTPClient() {
        return this.client;
    }

    private void useDedicatedSession(boolean autoCommit) throws AGHttpException {
        if (this.sessionRoot == null) {
            String url = AGProtocol.getSessionURL(this.getRoot());
            Header[] headers = new Header[]{};
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
            params.add(new NameValuePair("lifetime", Integer.toString(this.lifetimeInSeconds)));
            params.add(new NameValuePair("autoCommit", Boolean.toString(autoCommit)));
            params.add(new NameValuePair("loadInitFile", Boolean.toString(this.loadInitFile)));
            if (this.scripts != null) {
                for (String script : this.scripts) {
                    params.add(new NameValuePair("script", script));
                }
            }
            AGStringHandler handler = new AGStringHandler();
            this.getHTTPClient().post(url, headers, params.toArray(new NameValuePair[params.size()]), null, handler);
            this.usingDedicatedSession = true;
            this.sessionRoot = this.adjustSessionUrlIfUsingMainPort(handler.getResult());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("openSession: {}", (Object)this.sessionRoot);
            }
        }
    }

    private String adjustSessionUrlIfUsingMainPort(String dedicatedSessionUrl) throws AGHttpException {
        if (this.usingMainPortForSessions()) {
            String tail = dedicatedSessionUrl.substring(dedicatedSessionUrl.lastIndexOf(58) + 1);
            String port = tail.substring(0, tail.indexOf(47));
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new AGHttpException("problem finding port in session url: " + tail);
            }
            return this.repoRoot + "/session/" + tail;
        }
        return dedicatedSessionUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(String sessionRoot) throws AGHttpException {
        if (sessionRoot != null && !this.getHTTPClient().isClosed()) {
            String url = AGProtocol.getSessionCloseLocation(sessionRoot);
            Header[] headers = new Header[]{};
            NameValuePair[] params = new NameValuePair[]{};
            try {
                this.getHTTPClient().post(url, headers, params, null, null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("closeSession: {}", (Object)url);
                }
            }
            finally {
                sessionRoot = null;
            }
        }
    }

    public void getStatements(Resource subj, URI pred, Value obj, String includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        AGValueFactory vf = this.getValueFactory();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            subj = this.getStorableResource(subj, vf);
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            obj = this.getStorableValue(obj, vf);
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (Resource ctx : contexts) {
            ctx = this.getStorableResource(ctx, vf);
            params.add(new NameValuePair("context", Protocol.encodeContext((Resource)ctx)));
        }
        params.add(new NameValuePair("infer", includeInferred));
        this.getHTTPClient().get(uri, headers, params.toArray(new NameValuePair[params.size()]), new AGRDFHandler(this.getPreferredRDFFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public void getStatements(RDFHandler handler, String ... ids) throws RDFHandlerException, AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot()) + "/id";
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String id : ids) {
            params.add(new NameValuePair("id", id));
        }
        this.getHTTPClient().get(uri, headers, params.toArray(new NameValuePair[params.size()]), new AGRDFHandler(this.getPreferredRDFFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public void addStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Content-Type", RDFFormat.NTRIPLES.getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        this.getHTTPClient().post(uri, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void deleteStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]), null);
    }

    public void setAutoCommit(boolean autoCommit) throws AGHttpException {
        this.useDedicatedSession(autoCommit);
        String url = AGProtocol.getAutoCommitLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("on", Boolean.toString(autoCommit))};
        this.getHTTPClient().post(url, headers, params, null, null);
        this.autoCommit = autoCommit;
    }

    public boolean isAutoCommit() throws AGHttpException {
        return this.autoCommit;
    }

    public void setUploadCommitPeriod(int period) {
        if (period < 0) {
            throw new IllegalArgumentException("upload commit period must be non-negative.");
        }
        this.uploadCommitPeriod = period;
    }

    public int getUploadCommitPeriod() {
        return this.uploadCommitPeriod;
    }

    public void commit() throws AGHttpException {
        String url = this.getRoot() + "/" + "commit";
        Header[] headers = new Header[]{};
        this.getHTTPClient().post(url, headers, new NameValuePair[0], null, null);
    }

    public void rollback() throws AGHttpException {
        String url = this.getRoot() + "/" + "rollback";
        Header[] headers = new Header[]{};
        this.getHTTPClient().post(url, headers, new NameValuePair[0], null, null);
    }

    public void clearNamespaces() throws AGHttpException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        this.getHTTPClient().delete(url, headers, new NameValuePair[0], null);
    }

    public void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws RDFParseException, AGHttpException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        RequestEntity entity = new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                String format = dataFormat.getDefaultMIMEType();
                if (format.contains("turtle")) {
                    format = "text/turtle";
                }
                return format + "; charset=" + charset.name();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                IOUtil.transfer((Reader)contents, (Writer)writer);
                writer.flush();
            }
        };
        this.upload(entity, baseURI, overwrite, null, null, null, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, Resource ... contexts) throws RDFParseException, AGHttpException {
        String format = dataFormat.getDefaultMIMEType();
        if (format.contains("turtle")) {
            format = "text/turtle";
        }
        InputStreamRequestEntity entity = new InputStreamRequestEntity(contents, -1L, format);
        this.upload((RequestEntity)entity, baseURI, overwrite, null, null, null, contexts);
    }

    public void sendRDFTransaction(InputStream rdftransaction) throws AGHttpException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(rdftransaction, -1L, "application/x-rdftransaction");
        this.upload((RequestEntity)entity, null, false, null, null, null, new Resource[0]);
    }

    public void uploadJSON(JSONArray rows, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.uploadJSON(url, rows, contexts);
    }

    public void uploadJSON(String url, JSONArray rows, Resource ... contexts) throws AGHttpException {
        if (rows == null) {
            return;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(rows.toString().getBytes("UTF-8"));
            InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)in, -1L, "application/json");
            this.upload(url, (RequestEntity)entity, null, false, null, null, null, contexts);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteJSON(JSONArray rows, Resource ... contexts) throws AGHttpException {
        this.uploadJSON(AGProtocol.getStatementsDeleteLocation(this.getRoot()), rows, contexts);
    }

    public void load(URI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, null, source, dataFormat, contexts);
    }

    public void load(String serverAbsolutePath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, serverAbsolutePath, null, dataFormat, contexts);
    }

    public void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, URI serverSideURL, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, contexts);
    }

    public void upload(String url, RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, URI serverSideURL, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ArrayList<Header> headers = new ArrayList<Header>(1);
        if (dataFormat != null) {
            String format = dataFormat.getDefaultMIMEType();
            if (format.contains("turtle")) {
                format = "text/turtle";
            }
            headers.add(new Header("Content-Type", format));
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        if (baseURI != null && baseURI.trim().length() != 0) {
            String encodedBaseURI = Protocol.encodeValue((Value)new URIImpl(baseURI));
            params.add(new NameValuePair("baseURI", encodedBaseURI));
        }
        if (this.uploadCommitPeriod > 0) {
            params.add(new NameValuePair("commit", Integer.toString(this.uploadCommitPeriod)));
        }
        if (serverSideFile != null && serverSideFile.trim().length() != 0) {
            params.add(new NameValuePair("file", serverSideFile));
        }
        if (serverSideURL != null) {
            params.add(new NameValuePair("url", serverSideURL.stringValue()));
        }
        if (overwrite) {
            throw new UnsupportedOperationException();
        }
        this.getHTTPClient().post(url, headers.toArray(new Header[headers.size()]), params.toArray(new NameValuePair[params.size()]), reqEntity, null);
    }

    public TupleQueryResult getContextIDs() throws AGHttpException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, AGHttpException {
        String url = Protocol.getContextsLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType())};
        this.getHTTPClient().get(url, headers, new NameValuePair[0], new AGTQRHandler(this.getPreferredTQRFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public long size(Resource ... contexts) throws AGHttpException {
        String url = Protocol.getSizeLocation((String)this.getRoot());
        Header[] headers = new Header[]{};
        String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
        NameValuePair[] contextParams = new NameValuePair[encodedContexts.length];
        for (int i = 0; i < encodedContexts.length; ++i) {
            contextParams[i] = new NameValuePair("context", encodedContexts[i]);
        }
        AGLongHandler handler = new AGLongHandler();
        this.getHTTPClient().get(url, headers, contextParams, handler);
        return handler.getResult();
    }

    public TupleQueryResult getNamespaces() throws AGHttpException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, AGHttpException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType())};
        this.getHTTPClient().get(url, headers, new NameValuePair[0], new AGTQRHandler(this.getPreferredTQRFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public String getNamespace(String prefix) throws AGHttpException {
        AGStringHandler handler;
        block2: {
            String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
            Header[] headers = new Header[]{};
            handler = new AGStringHandler();
            try {
                this.getHTTPClient().get(url, headers, new NameValuePair[0], handler);
            }
            catch (AGHttpException e) {
                if (e.getMessage().equals("Not found.")) break block2;
                throw e;
            }
        }
        return handler.getResult();
    }

    public void setNamespacePrefix(String prefix, String name) throws AGHttpException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        try {
            this.getHTTPClient().put(url, headers, params, (RequestEntity)new StringRequestEntity(name, "text/plain", "UTF-8"), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeNamespacePrefix(String prefix) throws AGHttpException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        Header[] headers = new Header[]{};
        this.getHTTPClient().delete(url, headers, new NameValuePair[0], null);
    }

    public void query(AGQuery q, boolean analyzeOnly, AGResponseHandler handler) throws AGHttpException {
        String url = this.getRoot();
        if (q.isPrepared()) {
            this.processSavedQueryDeleteQueue();
            url = AGProtocol.getSavedQueryLocation(url, q.getName());
        }
        ArrayList<Header> headers = new ArrayList<Header>(5);
        headers.add(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        if (handler.getRequestMIMEType() != null) {
            headers.add(new Header("Accept", handler.getRequestMIMEType()));
        }
        List<NameValuePair> queryParams = this.getQueryMethodParameters(q);
        if (analyzeOnly) {
            queryParams.add(new NameValuePair("analyzeIndicesUsed", Boolean.toString(analyzeOnly)));
        }
        this.getHTTPClient().post(url, headers.toArray(new Header[headers.size()]), queryParams.toArray(new NameValuePair[queryParams.size()]), null, handler);
        if (this.sessionRoot != null && q.getName() != null) {
            q.setPrepared(true);
        }
    }

    protected List<NameValuePair> getQueryMethodParameters(AGQuery q) {
        QueryLanguage ql = q.getLanguage();
        Dataset dataset = q.getDataset();
        boolean includeInferred = q.getIncludeInferred();
        String planner = q.getPlanner();
        Binding[] bindings = q.getBindingsArray();
        String save = q.getName();
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        if (!q.isPrepared()) {
            queryParams.add(new NameValuePair("queryLn", ql.getName()));
            if (q instanceof AGUpdate) {
                queryParams.add(new NameValuePair("update", q.getQueryString()));
            } else {
                queryParams.add(new NameValuePair("query", q.getQueryString()));
            }
            if (q.getBaseURI() != null) {
                queryParams.add(new NameValuePair("baseURI", q.getBaseURI()));
            }
            if (q.getMaxQueryTime() > 0) {
                queryParams.add(new NameValuePair("timeout", Integer.toString(q.getMaxQueryTime())));
            }
            queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
            if (q.isCheckVariables()) {
                queryParams.add(new NameValuePair("checkVariables", Boolean.toString(q.isCheckVariables())));
            }
            if (q.getLimit() >= 0) {
                queryParams.add(new NameValuePair("limit", Integer.toString(q.getLimit())));
            }
            if (q.getOffset() >= 0) {
                queryParams.add(new NameValuePair("offset", Integer.toString(q.getOffset())));
            }
            if (q.isLoggingEnabled()) {
                queryParams.add(new NameValuePair("logQuery", "true"));
            }
            if (planner != null) {
                queryParams.add(new NameValuePair("planner", planner));
            }
            if (q.getEngine() != null) {
                queryParams.add(new NameValuePair("engine", q.getEngine()));
            }
            if (this.sessionRoot != null && save != null) {
                queryParams.add(new NameValuePair("save", save));
            }
            if (ql == QueryLanguage.SPARQL && dataset != null) {
                if (q instanceof AGUpdate) {
                    for (URI graphURI : dataset.getDefaultRemoveGraphs()) {
                        queryParams.add(new NameValuePair("remove-graph-uri", String.valueOf(graphURI)));
                    }
                    if (dataset.getDefaultInsertGraph() != null) {
                        queryParams.add(new NameValuePair("insert-graph-uri", String.valueOf(dataset.getDefaultInsertGraph())));
                    }
                    for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                        queryParams.add(new NameValuePair("using-graph-uri", String.valueOf(defaultGraphURI)));
                    }
                    for (URI namedGraphURI : dataset.getNamedGraphs()) {
                        queryParams.add(new NameValuePair("using-named-graph-uri", String.valueOf(namedGraphURI)));
                    }
                } else {
                    for (URI defaultGraphURI : dataset.getDefaultGraphs()) {
                        if (defaultGraphURI == null) {
                            queryParams.add(new NameValuePair("context", "null"));
                            continue;
                        }
                        queryParams.add(new NameValuePair("default-graph-uri", defaultGraphURI.toString()));
                    }
                    for (URI namedGraphURI : dataset.getNamedGraphs()) {
                        queryParams.add(new NameValuePair("named-graph-uri", namedGraphURI.toString()));
                    }
                }
            }
        }
        for (int i = 0; i < bindings.length; ++i) {
            String paramName = "$" + bindings[i].getName();
            String paramValue = Protocol.encodeValue((Value)this.getStorableValue(bindings[i].getValue(), this.getValueFactory()));
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    private void processSavedQueryDeleteQueue() throws AGHttpException {
        String queryName;
        while ((queryName = this.savedQueryDeleteQueue.poll()) != null) {
            this.deleteSavedQuery(queryName);
        }
    }

    public void deleteSavedQuery(String queryName) throws AGHttpException {
        String url = AGProtocol.getSavedQueryLocation(this.getRoot(), queryName);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    @Override
    public synchronized void close() throws AGHttpException {
        if (this.sessionRoot != null) {
            this.closeSession(this.sessionRoot);
            this.sessionRoot = null;
        }
    }

    public void createFreetextIndex(String name, List<String> predicates, boolean indexLiterals, List<String> indexLiteralTypes, String indexResources, List<String> indexFields, int minimumWordSize, List<String> stopWords, List<String> wordFilters, List<String> innerChars, List<String> borderChars, String tokenizer) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), name);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (predicates != null) {
            for (String pred : predicates) {
                params.add(new NameValuePair("predicate", pred));
            }
        }
        if (indexLiterals) {
            if (indexLiteralTypes != null) {
                for (String type : indexLiteralTypes) {
                    params.add(new NameValuePair("indexLiteralType", type));
                }
            }
        } else {
            params.add(new NameValuePair("indexLiterals", Boolean.toString(indexLiterals)));
        }
        if (!indexResources.equals("true")) {
            params.add(new NameValuePair("indexResources", indexResources));
        }
        if (indexFields != null) {
            for (String field : indexFields) {
                params.add(new NameValuePair("indexField", field));
            }
        }
        if (minimumWordSize != 3) {
            params.add(new NameValuePair("minimumWordSize", Integer.toString(minimumWordSize)));
        }
        if (stopWords != null) {
            for (String word : stopWords) {
                params.add(new NameValuePair("stopWord", word));
            }
        }
        if (wordFilters != null) {
            for (String filter : wordFilters) {
                params.add(new NameValuePair("wordFilter", filter));
            }
        }
        if (innerChars != null) {
            for (String inner : innerChars) {
                params.add(new NameValuePair("innerChars", inner));
            }
        }
        if (borderChars != null) {
            for (String border : borderChars) {
                params.add(new NameValuePair("borderChars", border));
            }
        }
        if (tokenizer != "default") {
            params.add(new NameValuePair("tokenizer", tokenizer));
        }
        this.getHTTPClient().put(url, new Header[0], params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void deleteFreetextIndex(String index) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public List<String> listFreetextIndices() throws AGHttpException {
        return Arrays.asList(this.getFreetextIndices());
    }

    public String[] getFreetextIndices() throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        return handler.getResult().split("\n");
    }

    public JSONObject getFreetextIndexConfiguration(String index) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index);
        AGJSONHandler handler = new AGJSONHandler();
        this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        return handler.getResult();
    }

    public String[] getFreetextPredicates(String index) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index) + "/predicates";
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        return handler.getResult().split("\n");
    }

    public void evalFreetextQuery(String pattern, String expression, String index, boolean sorted, int limit, int offset, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getFreetextLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(5);
        headers.add(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        if (handler.getRequestMIMEType() != null) {
            headers.add(new Header("Accept", handler.getRequestMIMEType()));
        }
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(6);
        if (pattern != null) {
            queryParams.add(new NameValuePair("pattern", pattern));
        }
        if (expression != null) {
            queryParams.add(new NameValuePair("expression", expression));
        }
        if (index != null) {
            queryParams.add(new NameValuePair("index", index));
        }
        if (sorted) {
            queryParams.add(new NameValuePair("sorted", Boolean.toString(sorted)));
        }
        if (limit > 0) {
            queryParams.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        if (offset > 0) {
            queryParams.add(new NameValuePair("offset", Integer.toString(offset)));
        }
        this.getHTTPClient().post(url, headers.toArray(new Header[headers.size()]), queryParams.toArray(new NameValuePair[queryParams.size()]), null, handler);
    }

    public void registerPredicateMapping(URI predicate, URI primitiveType) throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((URI)predicate);
        String primtype_nt = NTriplesUtil.toNTriplesString((URI)primitiveType);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("predicate", pred_nt), new NameValuePair("encoding", primtype_nt)};
        this.getHTTPClient().post(url, headers, params, null, null);
    }

    public void deletePredicateMapping(URI predicate) throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((URI)predicate);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("predicate", pred_nt)};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public String[] getPredicateMappings() throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        String result = handler.getResult();
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public void registerDatatypeMapping(URI datatype, URI primitiveType) throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((URI)datatype);
        String primtype_nt = NTriplesUtil.toNTriplesString((URI)primitiveType);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("type", datatype_nt), new NameValuePair("encoding", primtype_nt)};
        this.getHTTPClient().post(url, headers, params, null, null);
    }

    public void deleteDatatypeMapping(URI datatype) throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((URI)datatype);
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("type", datatype_nt)};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public String[] getDatatypeMappings() throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        String result = handler.getResult();
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public void clearMappings() throws AGHttpException {
        this.clearMappings(false);
    }

    public void clearMappings(boolean includeAutoEncodedPrimitiveTypes) throws AGHttpException {
        String url = AGProtocol.getMappingLocation(this.getRoot());
        if (includeAutoEncodedPrimitiveTypes) {
            url = url + "/all";
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void addRules(String rules) throws AGHttpException {
        ByteArrayInputStream rulestream;
        try {
            rulestream = new ByteArrayInputStream(rules.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.addRules(rulestream);
    }

    public void addRules(InputStream rulestream) throws AGHttpException {
        this.useDedicatedSession(this.isAutoCommit());
        String url = AGProtocol.getFunctorLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        InputStreamRequestEntity entity = new InputStreamRequestEntity(rulestream, -1L, null);
        this.getHTTPClient().post(url, headers, params, (RequestEntity)entity, null);
    }

    public String evalInServer(String lispForm) throws AGHttpException {
        ByteArrayInputStream stream;
        try {
            stream = new ByteArrayInputStream(lispForm.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String result = this.evalInServer(stream);
        return result;
    }

    public String evalInServer(InputStream stream) throws AGHttpException {
        String url = AGProtocol.getEvalLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        InputStreamRequestEntity entity = new InputStreamRequestEntity(stream, -1L, null);
        this.getHTTPClient().post(url, headers, params, (RequestEntity)entity, handler);
        return handler.getResult();
    }

    public void ping() throws AGHttpException {
        if (this.usingDedicatedSession) {
            String url = AGProtocol.getSessionPingLocation(this.getRoot());
            Header[] headers = new Header[]{};
            this.getHTTPClient().get(url, headers, new NameValuePair[0], null);
        }
    }

    public String[] getGeoTypes() throws AGHttpException {
        String url = AGProtocol.getGeoTypesLocation(this.getRoot());
        Header[] headers = new Header[]{};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, headers, new NameValuePair[0], handler);
        return handler.getResult().split("\n");
    }

    public String registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws AGHttpException {
        String url = AGProtocol.getGeoTypesCartesianLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("stripWidth", Float.toString(stripWidth)), new NameValuePair("xmin", Float.toString(xmin)), new NameValuePair("xmax", Float.toString(xmax)), new NameValuePair("ymin", Float.toString(ymin)), new NameValuePair("ymax", Float.toString(ymax))};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().post(url, headers, params, null, handler);
        return handler.getResult();
    }

    public String registerSphericalType(float stripWidth, String unit, float latmin, float longmin, float latmax, float longmax) throws AGHttpException {
        String url = AGProtocol.getGeoTypesSphericalLocation(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("stripWidth", Float.toString(stripWidth)), new NameValuePair("unit", unit), new NameValuePair("latmin", Float.toString(latmin)), new NameValuePair("longmin", Float.toString(longmin)), new NameValuePair("latmax", Float.toString(latmax)), new NameValuePair("longmax", Float.toString(longmax))};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().post(url, headers, params, null, handler);
        return handler.getResult();
    }

    public void registerPolygon(String polygon, List<String> points) throws AGHttpException {
        if (points.size() < 3) {
            throw new IllegalArgumentException("A minimum of three points are required to register a polygon.");
        }
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("resource", polygon));
        for (String point : points) {
            params.add(new NameValuePair("point", point));
        }
        this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void getGeoBox(String type_uri, String predicate_uri, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoBoxLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("xmin", Float.toString(xmin)));
        params.add(new NameValuePair("xmax", Float.toString(xmax)));
        params.add(new NameValuePair("ymin", Float.toString(ymin)));
        params.add(new NameValuePair("ymax", Float.toString(ymax)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
    }

    public void getGeoCircle(String type_uri, String predicate_uri, float x, float y, float radius, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoCircleLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("x", Float.toString(x)));
        params.add(new NameValuePair("y", Float.toString(y)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
    }

    public void getGeoHaversine(String type_uri, String predicate_uri, float lat, float lon, float radius, String unit, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoHaversineLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("lat", Float.toString(lat)));
        params.add(new NameValuePair("long", Float.toString(lon)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
    }

    public void getGeoPolygon(String type_uri, String predicate_uri, String polygon, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        Header[] headers = new Header[]{new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType())};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("polygon", polygon));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.getHTTPClient().get(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
    }

    public void registerSNAGenerator(String generator, List<String> objectOfs, List<String> subjectOfs, List<String> undirecteds, String query) throws AGHttpException {
        this.useDedicatedSession(this.autoCommit);
        String url = AGProtocol.getSNAGeneratorLocation(this.getRoot(), generator);
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        for (String objectOf : objectOfs) {
            params.add(new NameValuePair("objectOf", objectOf));
        }
        for (String subjectOf : subjectOfs) {
            params.add(new NameValuePair("subjectOf", subjectOf));
        }
        for (String undirected : undirecteds) {
            params.add(new NameValuePair("undirected", undirected));
        }
        if (query != null) {
            params.add(new NameValuePair("query", query));
        }
        this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<String> group, int depth) throws AGHttpException {
        String url = AGProtocol.getSNANeighborMatrixLocation(this.getRoot(), matrix);
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("generator", generator));
        for (String node : group) {
            params.add(new NameValuePair("group", node));
        }
        params.add(new NameValuePair("depth", Integer.toString(depth)));
        this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public List<String> listIndices(boolean listValid) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot());
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("listValid", Boolean.toString(listValid))};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, headers, data, handler);
        return Arrays.asList(handler.getResult().split("\n"));
    }

    public void addIndex(String index) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void dropIndex(String index) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void registerEncodableNamespace(String namespace, String format) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("prefix", namespace));
        params.add(new NameValuePair("format", format));
        this.getHTTPClient().post(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void unregisterEncodableNamespace(String namespace) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("prefix", namespace));
        this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]), null);
    }

    public void enableTripleCache(long size) throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("size", Long.toString(size))};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void registerEncodableNamespaces(JSONArray formattedNamespaces) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        this.uploadJSON(url, formattedNamespaces, new Resource[0]);
    }

    public TupleQueryResult getEncodableNamespaces() throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        return this.getHTTPClient().getTupleQueryResult(url);
    }

    public String callStoredProcEncoded(String functionName, String moduleName, String argsEncoded) throws AGHttpException {
        String url = AGProtocol.getStoredProcLocation(this.getRoot()) + "/" + functionName;
        Header[] headers = new Header[]{new Header("x-scripts", moduleName)};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("spargstr", argsEncoded)};
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().post(url, headers, params, null, handler);
        return handler.getResult();
    }

    public Object callStoredProc(String functionName, String moduleName, Object ... args) throws AGHttpException {
        Object[] a;
        Object o = AGDeserializer.decodeAndDeserialize(this.callStoredProcEncoded(functionName, moduleName, AGSerializer.serializeAndEncode(args)));
        if (o instanceof Object[] && (a = (Object[])o).length == 2 && "_fail_".equals(a[0])) {
            throw new AGCustomStoredProcException(a[1] == null ? null : a[1].toString());
        }
        return o;
    }

    public long getTripleCacheSize() throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        AGLongHandler handler = new AGLongHandler();
        this.getHTTPClient().get(url, headers, data, handler);
        return handler.getResult();
    }

    public void disableTripleCache() throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public String[] getBlankNodes(int blankNodeAmount) throws AGHttpException {
        return this.getHTTPClient().getBlankNodes(this.getRoot(), blankNodeAmount);
    }

    public void deleteDuplicates(String comparisonMode) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot()) + "/duplicates";
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        if (comparisonMode != null) {
            params.add(new NameValuePair("mode", comparisonMode));
        }
        this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]), null);
    }

    public long materialize(AGMaterializer materializer) throws AGHttpException {
        String url = this.getRoot() + "/materializeEntailed";
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (materializer != null) {
            Boolean useTypeSubproperty;
            for (String with : materializer.getWithRulesets()) {
                params.add(new NameValuePair("with", with));
            }
            for (String without : materializer.getWithoutRulesets()) {
                params.add(new NameValuePair("without", without));
            }
            Integer period = materializer.getCommitPeriod();
            if (period != null) {
                params.add(new NameValuePair("commit", period.toString()));
            }
            if ((useTypeSubproperty = materializer.getUseTypeSubproperty()) != null) {
                params.add(new NameValuePair("useTypeSubproperty", useTypeSubproperty.toString()));
            }
        }
        AGLongHandler handler = new AGLongHandler();
        this.getHTTPClient().put(url, headers, params.toArray(new NameValuePair[params.size()]), null, handler);
        return handler.getResult();
    }

    public long deleteMaterialized() throws RepositoryException {
        String url = this.getRoot() + "/materializeEntailed";
        Header[] headers = new Header[]{};
        ArrayList params = new ArrayList(2);
        AGLongHandler handler = new AGLongHandler();
        this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]), handler);
        return handler.getResult();
    }

    public void optimizeIndices(Boolean wait, int level) throws AGHttpException {
        String url = this.repoRoot + "/indices/optimize";
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("wait", Boolean.toString(wait)), new NameValuePair("level", Integer.toString(level))};
        this.getHTTPClient().post(url, headers, params, null, null);
    }

    public void optimizeIndices(Boolean wait) throws AGHttpException {
        String url = this.repoRoot + "/indices/optimize";
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("wait", Boolean.toString(wait))};
        this.getHTTPClient().post(url, headers, params, null, null);
    }

    private void putSpinX(String x, AGSpinFunction fn) throws AGHttpException {
        NameValuePair[] params = new NameValuePair[(fn.getArguments() == null ? 0 : fn.getArguments().length) + 1];
        params[0] = new NameValuePair("query", fn.getQuery());
        for (int i = 0; fn.getArguments() != null && i < fn.getArguments().length; ++i) {
            params[i + 1] = new NameValuePair("arguments", fn.getArguments()[i]);
        }
        this.getHTTPClient().put(AGProtocol.spinURL(this.getRoot(), x, fn.getUri()), null, params, null, null);
    }

    public String getSpinFunction(String uri) throws AGHttpException {
        return this.getHTTPClient().getString(AGProtocol.spinURL(this.getRoot(), "function", uri));
    }

    public TupleQueryResult listSpinFunctions() throws AGHttpException {
        return this.getHTTPClient().getTupleQueryResult(AGProtocol.spinURL(this.getRoot(), "function", null));
    }

    public void putSpinFunction(AGSpinFunction fn) throws AGHttpException {
        this.putSpinX("function", fn);
    }

    public void deleteSpinFunction(String uri) throws AGHttpException {
        this.getHTTPClient().delete(AGProtocol.spinURL(this.getRoot(), "function", uri), null, null, null);
    }

    public void deleteHardSpinFunction(String uri) throws AGHttpException {
        block2: {
            try {
                this.deleteSpinFunction(uri);
            }
            catch (AGHttpException e) {
                if (e.getMessage().contains(uri + " is not a registered SPIN function")) break block2;
                throw e;
            }
        }
    }

    public String getSpinMagicProperty(String uri) throws AGHttpException {
        return this.getHTTPClient().getString(AGProtocol.spinURL(this.getRoot(), "magicproperty", uri));
    }

    public TupleQueryResult listSpinMagicProperties() throws AGHttpException {
        return this.getHTTPClient().getTupleQueryResult(AGProtocol.spinURL(this.getRoot(), "magicproperty", null));
    }

    public void putSpinMagicProperty(AGSpinMagicProperty fn) throws AGHttpException {
        this.putSpinX("magicproperty", fn);
    }

    public void deleteSpinMagicProperty(String uri) throws AGHttpException {
        this.getHTTPClient().delete(AGProtocol.spinURL(this.getRoot(), "magicproperty", uri), null, null, null);
    }

    public void deleteHardSpinMagicProperty(String uri) throws AGHttpException {
        block2: {
            try {
                this.deleteSpinMagicProperty(uri);
            }
            catch (AGHttpException e) {
                if (e.getMessage().contains(uri + " is not a registered SPIN magic property")) break block2;
                throw e;
            }
        }
    }

    public void setAllowExternalBlankNodeIds(boolean allow) {
        this.allowExternalBlankNodeIds = allow;
    }

    public boolean getAllowExternalBlankNodeIds() {
        return this.allowExternalBlankNodeIds;
    }

    public Resource getStorableResource(Resource r, AGValueFactory vf) {
        Resource storable = r;
        if (r instanceof BNode && !vf.isAGBlankNodeId(r.stringValue())) {
            if (this.allowExternalBlankNodeIds) {
                storable = vf.createURI(vf.PREFIX_FOR_EXTERNAL_BNODES + r.stringValue());
            } else {
                throw new IllegalArgumentException("Cannot store external blank node " + r + " in AllegroGraph with the current settings. Please see javadoc for AGHttpRepoClient#setAllowExternalBlankNodeIds(boolean) for more details and options.");
            }
        }
        return storable;
    }

    public Value getStorableValue(Value v, AGValueFactory vf) {
        Value storable = v;
        if (v instanceof BNode && !vf.isAGBlankNodeId(v.stringValue())) {
            if (this.allowExternalBlankNodeIds) {
                storable = vf.createURI(vf.PREFIX_FOR_EXTERNAL_BNODES + v.stringValue());
            } else {
                throw new IllegalArgumentException("Cannot store external blank node " + v + " in AllegroGraph with the current settings. Please see javadoc for AGHttpRepoClient#setAllowExternalBlankNodeIds(boolean) for more details and options.");
            }
        }
        return storable;
    }

    public static Resource getApplicationResource(Resource stored, AGValueFactory vf) {
        Resource app = stored;
        if (stored instanceof URI && vf.isURIForExternalBlankNode((Value)stored)) {
            app = vf.createBNode(stored.stringValue().substring(vf.PREFIX_FOR_EXTERNAL_BNODES.length()));
        }
        return app;
    }

    public static Value getApplicationValue(Value stored, AGValueFactory vf) {
        Value app = stored;
        if (stored instanceof URI && vf.isURIForExternalBlankNode(stored)) {
            app = vf.createBNode(stored.stringValue().substring(vf.PREFIX_FOR_EXTERNAL_BNODES.length()));
        }
        return app;
    }

    public void setMasqueradeAsUser(String user) throws RepositoryException {
        this.useDedicatedSession(this.autoCommit);
        this.getHTTPClient().setMasqueradeAsUser(user);
    }
}

