/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGErrorHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.franz.util.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.TupleQueryResultBuilder;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHTTPClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(AGHTTPClient.class);
    private final String serverURL;
    private final HttpClient httpClient;
    private AuthScope authScope;
    private String masqueradeAsUser;
    private boolean isClosed = false;
    private MultiThreadedHttpConnectionManager mManager = null;

    public AGHTTPClient(String serverURL) {
        this(serverURL, null);
    }

    public AGHTTPClient(String serverURL, HttpConnectionManager manager) {
        this.serverURL = serverURL.replaceAll("/$", "");
        if (manager == null) {
            this.mManager = new MultiThreadedHttpConnectionManager();
            manager = this.mManager;
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setDefaultMaxConnectionsPerHost(Integer.MAX_VALUE);
            params.setMaxTotalConnections(Integer.MAX_VALUE);
            manager.setParams(params);
        }
        this.httpClient = new HttpClient(manager);
        if (logger.isDebugEnabled()) {
            logger.debug("connect: " + serverURL + " " + this.httpClient + " " + manager);
        }
    }

    public String toString() {
        return "{" + super.toString() + " " + this.serverURL + " " + this.httpClient + "}";
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        PostMethod post = new PostMethod(url);
        this.setDoAuthentication((HttpMethod)post);
        for (Header header : headers) {
            post.addRequestHeader(header);
        }
        post.addRequestHeader("Accept-encoding", "gzip");
        if (requestEntity == null) {
            post.setRequestBody(params);
        } else {
            post.setQueryString(params);
            post.setRequestEntity(requestEntity);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)post);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)post);
                }
            } else {
                if (httpCode == 401) {
                    throw new AGHttpException((Exception)new UnauthorizedException());
                }
                if (!this.is2xx(httpCode)) {
                    AGErrorHandler errHandler = new AGErrorHandler();
                    errHandler.handleResponse((HttpMethod)post);
                    throw errHandler.getResult();
                }
            }
        }
        catch (HttpException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleSessionConnectionError(e, url);
        }
        finally {
            if (handler == null || handler.releaseConnection()) {
                this.releaseConnection((HttpMethod)post);
            }
        }
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        GetMethod get = new GetMethod(url);
        this.setDoAuthentication((HttpMethod)get);
        if (headers != null) {
            for (Header header : headers) {
                get.addRequestHeader(header);
            }
        }
        get.addRequestHeader("Accept-encoding", "gzip");
        if (params != null) {
            get.setQueryString(params);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)get);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)get);
                }
            } else {
                if (httpCode == 401) {
                    throw new AGHttpException((Exception)new UnauthorizedException());
                }
                if (!this.is2xx(httpCode)) {
                    AGErrorHandler errHandler = new AGErrorHandler();
                    errHandler.handleResponse((HttpMethod)get);
                    throw errHandler.getResult();
                }
            }
        }
        catch (HttpException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleSessionConnectionError(e, url);
        }
        finally {
            if (handler == null || handler.releaseConnection()) {
                this.releaseConnection((HttpMethod)get);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String url, Header[] headers, NameValuePair[] params, AGResponseHandler handler) throws AGHttpException {
        DeleteMethod delete = new DeleteMethod(url);
        this.setDoAuthentication((HttpMethod)delete);
        if (headers != null) {
            for (Header header : headers) {
                delete.addRequestHeader(header);
            }
        }
        if (params != null) {
            delete.setQueryString(params);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)delete);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)delete);
                }
            } else {
                if (httpCode == 401) {
                    throw new AGHttpException((Exception)new UnauthorizedException());
                }
                if (!this.is2xx(httpCode)) {
                    AGErrorHandler errHandler = new AGErrorHandler();
                    errHandler.handleResponse((HttpMethod)delete);
                    throw errHandler.getResult();
                }
            }
        }
        catch (HttpException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleSessionConnectionError(e, url);
        }
        finally {
            if (handler == null || handler.releaseConnection()) {
                this.releaseConnection((HttpMethod)delete);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String url, Header[] headers, NameValuePair[] params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        PutMethod put = new PutMethod(url);
        this.setDoAuthentication((HttpMethod)put);
        if (headers != null) {
            for (Header header : headers) {
                put.addRequestHeader(header);
            }
        }
        if (params != null) {
            put.setQueryString(params);
        }
        if (requestEntity != null) {
            put.setRequestEntity(requestEntity);
        }
        try {
            int httpCode = this.getHttpClient().executeMethod((HttpMethod)put);
            if (httpCode == 200) {
                if (handler != null) {
                    handler.handleResponse((HttpMethod)put);
                }
            } else {
                if (httpCode == 401) {
                    throw new AGHttpException((Exception)new UnauthorizedException());
                }
                if (!this.is2xx(httpCode)) {
                    AGErrorHandler errHandler = new AGErrorHandler();
                    errHandler.handleResponse((HttpMethod)put);
                    throw errHandler.getResult();
                }
            }
        }
        catch (HttpException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleSessionConnectionError(e, url);
        }
        finally {
            if (handler == null || handler.releaseConnection()) {
                this.releaseConnection((HttpMethod)put);
            }
        }
    }

    public void setUsernameAndPassword(String username, String password) {
        if (username != null && password != null) {
            logger.debug("Setting username '{}' and password for server at {}.", (Object)username, (Object)this.serverURL);
            try {
                URL server = new URL(this.serverURL);
                this.authScope = new AuthScope(server.getHost(), -1);
                this.httpClient.getState().setCredentials(this.authScope, (Credentials)new UsernamePasswordCredentials(username, password));
                this.httpClient.getParams().setAuthenticationPreemptive(true);
            }
            catch (MalformedURLException e) {
                logger.warn("Unable to set username and password for malformed URL " + this.serverURL, (Throwable)e);
            }
        } else {
            this.authScope = null;
            this.httpClient.getState().clearCredentials();
            this.httpClient.getParams().setAuthenticationPreemptive(false);
        }
    }

    public void setMasqueradeAsUser(String user) throws AGHttpException {
        this.masqueradeAsUser = user;
    }

    protected final void setDoAuthentication(HttpMethod method) {
        if (this.authScope != null && this.httpClient.getState().getCredentials(this.authScope) != null) {
            method.setDoAuthentication(true);
        }
        if (this.masqueradeAsUser != null) {
            method.addRequestHeader(new Header("x-masquerade-as-user", this.masqueradeAsUser));
        }
        method.addRequestHeader(new Header("Connection", "keep-alive"));
    }

    protected final void releaseConnection(HttpMethod method) {
        try {
            InputStream responseStream = method.getResponseBodyAsStream();
            if (responseStream != null) {
                while (responseStream.read() >= 0) {
                }
            }
            method.releaseConnection();
        }
        catch (IOException e) {
            logger.warn("I/O error upon releasing connection", (Throwable)e);
        }
    }

    public void putCatalog(String catalogURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putCatalog: " + catalogURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.put(catalogURL, headers, params, null, null);
    }

    public void deleteCatalog(String catalogURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(catalogURL, headers, params, null);
    }

    public void putRepository(String repositoryURL) throws AGHttpException {
        if (logger.isDebugEnabled()) {
            logger.debug("putRepository: " + repositoryURL);
        }
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("override", "false")};
        this.put(repositoryURL, headers, params, null, null);
    }

    public void deleteRepository(String repositoryURL) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.delete(repositoryURL, headers, params, null);
    }

    public TupleQueryResult getTupleQueryResult(String url) throws AGHttpException {
        Header[] headers = new Header[]{new Header("Accept", TupleQueryResultFormat.SPARQL.getDefaultMIMEType())};
        NameValuePair[] params = new NameValuePair[]{};
        TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
        AGTQRHandler handler = new AGTQRHandler(TupleQueryResultFormat.SPARQL, (TupleQueryResultHandler)builder, new AGValueFactory(null), false);
        this.get(url, headers, params, handler);
        return builder.getQueryResult();
    }

    public String[] getBlankNodes(String repositoryURL, int amount) throws AGHttpException {
        String url = AGProtocol.getBlankNodesURL(repositoryURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    public String getString(String url) throws AGHttpException {
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{};
        AGStringHandler handler = new AGStringHandler();
        this.get(url, headers, data, handler);
        return handler.getResult();
    }

    public String[] getStringArray(String url) throws AGHttpException {
        String result = this.getString(url);
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public List<String> getListOfStrings(String url) throws AGHttpException {
        return Arrays.asList(this.getStringArray(url));
    }

    public String openSession(String spec, boolean autocommit) throws AGHttpException {
        String url = AGProtocol.getSessionURL(this.serverURL);
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("store", spec), new NameValuePair("autoCommit", Boolean.toString(autocommit)), new NameValuePair("lifetime", Long.toString(3600L))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult();
    }

    @Override
    public void close() {
        logger.debug("close: " + this.serverURL + " " + this.mManager);
        this.mManager = Closer.Close(this.mManager);
        this.isClosed = true;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    public String[] generateURIs(String repositoryURL, String namespace, int amount) throws AGHttpException {
        String url = repositoryURL + "/encodedIds";
        Header[] headers = new Header[]{};
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("prefix", namespace), new NameValuePair("amount", Integer.toString(amount))};
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, data, null, handler);
        return handler.getResult().split("\n");
    }

    private void handleSessionConnectionError(IOException e, String url) throws AGHttpException {
        if (e instanceof ConnectException) {
            throw new AGHttpException("Session port connection failure. Consult the Server Installation document for correct settings for SessionPorts. Url: " + url + ". Documentation: http://www.franz.com/agraph/support/documentation/v4/server-installation.html#sessionport", e);
        }
        throw new AGHttpException("Possible session port connection failure. Consult the Server Installation document for correct settings for SessionPorts. Url: " + url + ". Documentation: http://www.franz.com/agraph/support/documentation/v4/server-installation.html#sessionport", e);
    }
}

