/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.jsmodify.executionTracer;

import com.crawljax.plugins.jsmodify.executionTracer.Trace;
import com.crawljax.util.Helper;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class JSExecutionTracer {
    private static final int ONE_SEC = 1000;
    private static String outputFolder;
    private static JSONArray points;
    public static final String EXECUTIONTRACEDIRECTORY = "executiontrace/";

    public JSExecutionTracer(String outFolder) {
        outputFolder = outFolder;
    }

    public void retrieveJSInstrResult(WebDriver browser) {
        String filename = this.getOutputFolder() + EXECUTIONTRACEDIRECTORY + "jsexecutiontrace-";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        filename = filename + dateFormat.format(date) + ".txt";
        try {
            JavascriptExecutor js = (JavascriptExecutor)browser;
            js.executeScript("sendReally();", new Object[0]);
            Thread.sleep(1000L);
            Trace trace = new Trace();
            PrintWriter file = new PrintWriter(filename);
            file.write(trace.parse(points));
            file.write(10);
            file.close();
            points = new JSONArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> allTraceFiles() {
        ArrayList<String> result = new ArrayList<String>();
        File dir = new File(this.getOutputFolder() + EXECUTIONTRACEDIRECTORY);
        String[] files = dir.list();
        if (files == null) {
            return result;
        }
        for (String file : files) {
            if (!file.endsWith(".txt")) continue;
            result.add(this.getOutputFolder() + EXECUTIONTRACEDIRECTORY + file);
        }
        return result;
    }

    public String getOutputFolder() {
        return Helper.addFolderSlashIfNeeded((String)outputFolder);
    }

    public void setOutputFolder(String absolutePath) {
        outputFolder = absolutePath;
    }

    public static void addPoint(String string) {
        JSONArray buffer = null;
        try {
            buffer = new JSONArray(string);
            for (int i = 0; i < buffer.length(); ++i) {
                points.put(buffer.get(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static {
        points = new JSONArray();
    }
}

