/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.jsmodify.executionTracer;

import com.crawljax.plugins.jsmodify.JSASTModifier;
import com.crawljax.util.Helper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.Symbol;

public abstract class AstInstrumenter
extends JSASTModifier {
    private List<String> excludeList = new ArrayList<String>();
    String jsFileNameToAttach;
    private boolean domModifications = false;

    public AstInstrumenter(String jsFileNameToAttach) {
        this.jsFileNameToAttach = jsFileNameToAttach;
        this.excludeList = new ArrayList<String>();
    }

    public AstInstrumenter(List<String> excludes) {
        this.excludeList = excludes;
    }

    private AstNode jsLoggingFunctions() {
        File js = new File(this.getClass().getResource(this.jsFileNameToAttach).getFile());
        String code = Helper.getContent((File)js);
        return this.parse(code);
    }

    @Override
    public abstract AstNode createNodeInFunction(FunctionNode var1, int var2);

    @Override
    public abstract AstNode createNode(AstNode ... var1);

    protected boolean shouldInstrument(String name) {
        if (name == null) {
            return false;
        }
        for (String regex : this.excludeList) {
            if (!name.matches(regex)) continue;
            return false;
        }
        return true;
    }

    protected String[] getVariablesNamesInScope(Scope scope) {
        TreeSet<String> result = new TreeSet<String>();
        do {
            Map t;
            if ((t = scope.getSymbolTable()) == null) continue;
            for (String key : t.keySet()) {
                Symbol symbol = (Symbol)t.get(key);
                if (symbol.getDeclType() != 87 && symbol.getDeclType() != 122) continue;
                result.add(symbol.getName());
            }
        } while ((scope = scope.getEnclosingScope()) != null);
        return result.toArray(new String[0]);
    }

    @Override
    public void finish(AstRoot node) {
        node.addChildToFront((Node)this.jsLoggingFunctions());
    }

    @Override
    public abstract void start();

    @Override
    public abstract AstNode createPointNode(String var1, int var2);

    protected boolean shouldInstrumentDOMModifications() {
        return this.domModifications;
    }

    public void instrumentDOMModifications() {
        this.domModifications = true;
    }
}

