/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.jsmodify;

import com.crawljax.plugins.jsmodify.JSASTModifier;
import com.crawljax.plugins.jsmodify.executionTracer.JSExecutionTracer;
import com.crawljax.util.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.NodeVisitor;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSModifyProxyPlugin
extends ProxyPlugin {
    private List<String> excludeFilenamePatterns = new ArrayList<String>();
    private final JSASTModifier modifier;

    public JSModifyProxyPlugin(JSASTModifier modify) {
        this.modifier = modify;
    }

    public JSModifyProxyPlugin(JSASTModifier modify, List<String> excludes) {
        this.excludeFilenamePatterns = excludes;
        this.modifier = modify;
    }

    public String getPluginName() {
        return "JSInstrumentPlugin";
    }

    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private boolean shouldModify(String name) {
        for (String pattern : this.excludeFilenamePatterns) {
            if (!name.matches(pattern)) continue;
            return false;
        }
        return true;
    }

    private synchronized String modifyJS(String input, String scopename) {
        if (!this.shouldModify(scopename)) {
            return input;
        }
        try {
            AstRoot ast = null;
            Context cx = Context.enter();
            Parser rhinoParser = new Parser(new CompilerEnvirons(), cx.getErrorReporter());
            ast = rhinoParser.parse(new String(input), scopename, 0);
            this.modifier.setScopeName(scopename);
            this.modifier.start();
            ast.visit((NodeVisitor)this.modifier);
            this.modifier.finish(ast);
            Context.exit();
            return ast.toSource();
        }
        catch (RhinoException re) {
            System.err.println(re.getMessage() + "Unable to instrument. This might be a JSON response sent" + " with the wrong Content-Type or a syntax error.");
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Invalid operator exception catched. Not instrumenting code.");
        }
        System.err.println("Here is the corresponding buffer: \n" + input + "\n");
        return input;
    }

    private Response createResponse(Response response, Request request) {
        String type = response.getHeader("Content-Type");
        if (request.getURL().toString().contains("?thisisanexecutiontracingcall")) {
            JSExecutionTracer.addPoint(new String(request.getContent()));
            return response;
        }
        if (type != null && type.contains("javascript")) {
            response.setContent(this.modifyJS(new String(response.getContent()), request.getURL().toString()).getBytes());
        } else if (type != null && type.contains("html")) {
            try {
                Document dom = Helper.getDocument((String)new String(response.getContent()));
                NodeList nodes = dom.getElementsByTagName("script");
                for (int i = 0; i < nodes.getLength(); ++i) {
                    String js;
                    String content;
                    Node nType = nodes.item(i).getAttributes().getNamedItem("type");
                    if (nType != null && nType.getTextContent() != null && nType.getTextContent().toLowerCase().contains("javascript") && (content = nodes.item(i).getTextContent()).length() > 0) {
                        js = this.modifyJS(content, request.getURL() + "script" + i);
                        nodes.item(i).setTextContent(js);
                        continue;
                    }
                    nType = nodes.item(i).getAttributes().getNamedItem("language");
                    if (nType == null || nType.getTextContent() == null || !nType.getTextContent().toLowerCase().contains("javascript") || (content = nodes.item(i).getTextContent()).length() <= 0) continue;
                    js = this.modifyJS(content, request.getURL() + "script" + i);
                    nodes.item(i).setTextContent(js);
                }
                if (nodes.getLength() > 0) {
                    response.setContent(Helper.getDocumentToByteArray((Document)dom));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return response;
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient client = null;

        public Plugin(HTTPClient in) {
            this.client = in;
        }

        public Response fetchResponse(Request request) throws IOException {
            Response response = this.client.fetchResponse(request);
            return JSModifyProxyPlugin.this.createResponse(response, request);
        }
    }
}

