/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.plugins.jsmodify;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.WhileLoop;

public abstract class JSASTModifier
implements NodeVisitor {
    private CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
    private String scopeName = null;

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public AstNode parse(String code) {
        Parser p = new Parser(this.compilerEnvirons, null);
        return p.parse(code, null, 0);
    }

    protected String getFunctionName(FunctionNode f) {
        Name functionName = f.getFunctionName();
        if (functionName == null) {
            return "anonymous" + f.getLineno();
        }
        return functionName.toSource();
    }

    public abstract AstNode createNodeInFunction(FunctionNode var1, int var2);

    public abstract AstNode createNode(AstNode ... var1);

    public abstract AstNode createPointNode(String var1, int var2);

    private Block createBlockWithNode(AstNode node) {
        Block b = new Block();
        b.addChild(node);
        return b;
    }

    public AstNode makeSureBlockExistsAround(AstNode node) {
        AstNode parent = node.getParent();
        if (parent instanceof IfStatement) {
            IfStatement i = (IfStatement)parent;
            if (i.getThenPart().equals(node)) {
                i.setThenPart((AstNode)this.createBlockWithNode(node));
            } else {
                i.setElsePart((AstNode)this.createBlockWithNode(node));
            }
        } else if (parent instanceof WhileLoop) {
            WhileLoop w = (WhileLoop)parent;
            w.setBody((AstNode)this.createBlockWithNode(node));
        } else if (parent instanceof ForLoop) {
            ForLoop f = (ForLoop)parent;
            f.setBody((AstNode)this.createBlockWithNode(node));
        }
        return node.getParent();
    }

    public abstract boolean visit(AstNode var1);

    public abstract void finish(AstRoot var1);

    public abstract void start();
}

