/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import org.junit.After;
import org.junit.Assert;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class SWRLAbstract {
    protected static String base;

    protected void test(String test) {
        this.testJena(this.url(test + "-premise.rdf"), this.url(test + "-conclusion.rdf"));
        this.testOWLAPIv3(this.url(test + "-premise.rdf"), this.url(test + "-conclusion.rdf"));
    }

    private void testJena(String premiseURI, String conclusionURI) {
        OntModel premise = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        premise.read(premiseURI);
        premise.prepare();
        Model conclusion = ModelFactory.createDefaultModel();
        conclusion.read(conclusionURI);
        StmtIterator stmtIter = conclusion.listStatements();
        while (stmtIter.hasNext()) {
            Statement s = stmtIter.nextStatement();
            Assert.assertTrue((boolean)premise.contains(s));
        }
    }

    private void testOWLAPIv3(String premiseURI, String conclusionURI) {
        OWLOntologyManager manager = null;
        try {
            manager = OWLManager.createOWLOntologyManager();
            OWLOntology premise = manager.loadOntology(IRI.create((String)premiseURI));
            manager = OWLManager.createOWLOntologyManager();
            OWLOntology conclusion = manager.loadOntology(IRI.create((String)conclusionURI));
            PelletReasoner reasoner = new com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory().createReasoner(premise);
            Assert.assertTrue((boolean)reasoner.isEntailed(conclusion.getAxioms()));
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }

    private String url(String filename) {
        return base + filename;
    }

    @After
    public void after() {
        OntologyUtils.clearOWLOntologyManager();
    }
}

